/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.number;

import com.cadwin.basic.misc.ValuesConstants;
import java.math.BigDecimal;
import java.util.Objects;

public abstract class StrBigDecimal
extends Number
implements Comparable<Object> {
    private final BigDecimal bd;

    protected StrBigDecimal(Object o) {
        this.bd = o == null ? null : (ValuesConstants.isDifferentValues(o) ? ValuesConstants.DIFFERENT_BIG_DECIMAL_VALUES : (o instanceof BigDecimal ? (BigDecimal)o : (o instanceof Double ? BigDecimal.valueOf((Double)o) : new BigDecimal(o.toString()))));
    }

    @Override
    public int intValue() {
        return this.bd == null ? Integer.MIN_VALUE : this.bd.intValue();
    }

    @Override
    public long longValue() {
        return this.bd == null ? Long.MIN_VALUE : this.bd.longValue();
    }

    @Override
    public float floatValue() {
        return this.bd == null ? Float.MAX_VALUE : this.bd.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bd == null ? Double.MIN_VALUE : this.bd.doubleValue();
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof StrBigDecimal) {
            StrBigDecimal otherBd = (StrBigDecimal)o;
            if (this.bd == null || otherBd.bd == null) {
                return Double.compare(this.doubleValue(), otherBd.doubleValue());
            }
            return this.bd.compareTo(otherBd.bd);
        }
        if (o instanceof Number) {
            Number otherNb = (Number)o;
            return Double.compare(this.doubleValue(), otherNb.doubleValue());
        }
        throw new IllegalArgumentException(o + " is not a number");
    }

    public boolean equals(Object obj) {
        return obj instanceof StrBigDecimal && Objects.equals(this.bd, ((StrBigDecimal)obj).bd);
    }

    public int hashCode() {
        return Objects.hash(this.bd);
    }

    public abstract double doubleValueInUserDefinedUnit();

    public abstract String toStringWithoutUnitDescription();

    public abstract Enum<?> getUnit();

    public String toString() {
        return this.bd == null ? null : this.bd.toString();
    }
}

