/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.number;

import com.cadwin.basic.misc.NumberUtil;
import com.cadwin.basic.misc.ValuesConstants;
import com.cadwin.basic.number.StrBigDecimal;
import com.cadwin.basic.number.UnitBaseInfos;

public class SurfaceBigDecimal
extends StrBigDecimal {
    private NumberUtil.SurfaceUnit surfaceUnit;

    public SurfaceBigDecimal(Object o) {
        this(o, null);
    }

    public SurfaceBigDecimal(Object o, NumberUtil.SurfaceUnit surfaceUnit) {
        super(o);
        this.surfaceUnit = surfaceUnit;
    }

    public NumberUtil.SurfaceUnit getUnit() {
        return this.surfaceUnit == null ? UnitBaseInfos.getSurfaceUnit() : this.surfaceUnit;
    }

    @Override
    public String toStringWithoutUnitDescription() {
        String result;
        if (ValuesConstants.isNull(this.doubleValue())) {
            result = "";
        } else {
            double value = this.doubleValueInUserDefinedUnit();
            result = UnitBaseInfos.getSurfaceFormatter(this.getUnit()).format(value);
        }
        return result;
    }

    @Override
    public String toString() {
        String resultWithoutUnitDesc = this.toStringWithoutUnitDescription();
        return resultWithoutUnitDesc.isEmpty() ? resultWithoutUnitDesc : resultWithoutUnitDesc + " " + this.getUnit().getDescription();
    }

    @Override
    public double doubleValueInUserDefinedUnit() {
        if (this.doubleValue() == Double.MIN_VALUE) {
            return this.doubleValue();
        }
        return this.doubleValue() * UnitBaseInfos.getInternalUnit() * UnitBaseInfos.getInternalUnit() / this.getUnit().getConvertFactor();
    }
}

