/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.pantone;

import com.cadwin.basic.pantone.PantoneType;
import java.awt.Color;
import java.io.Serializable;
import java.util.Objects;

public class PantoneColor
implements Serializable,
Comparable<PantoneColor> {
    private final PantoneType type;
    private final String pantoneName;
    private final String pantoneColor;
    private final Color color;
    private final long orderPos;

    public PantoneColor(PantoneType type, String pantoneName, String pantoneColor, Color color, long orderPos) {
        this.type = type;
        this.pantoneName = pantoneName;
        this.pantoneColor = pantoneColor;
        this.color = color;
        this.orderPos = orderPos;
    }

    public PantoneType getType() {
        return this.type;
    }

    public String getPantoneDescr() {
        return this.pantoneName != null ? this.pantoneName : this.pantoneColor;
    }

    public String getPantoneName() {
        return this.pantoneName;
    }

    public String getPantoneColor() {
        return this.pantoneColor;
    }

    public String getDescription() {
        return this.toString() + "  [" + Integer.toString(this.color.getRed()) + ", " + Integer.toString(this.color.getGreen()) + ", " + Integer.toString(this.color.getBlue()) + "]";
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.pantoneColor + (String)(this.pantoneName == null ? "" : " (" + this.pantoneName + ")");
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && Objects.equals(this.pantoneColor, ((PantoneColor)obj).pantoneColor);
    }

    public int hashCode() {
        return Objects.hash(this.pantoneColor);
    }

    @Override
    public int compareTo(PantoneColor otherPantoneColor) {
        if (otherPantoneColor.getType().equals((Object)this.getType())) {
            return (int)(this.orderPos - otherPantoneColor.orderPos);
        }
        return this.getType().ordinal() - otherPantoneColor.getType().ordinal();
    }
}

