/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.sql;

import com.cadwin.basic.io.IoUtil;
import com.cadwin.basic.xml.XslUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.TransformerException;

public class BlobUtil {
    private static InputStreamReader getGzippedBlobInputStreamReader(Blob blob) throws SQLException, IOException {
        GZIPInputStream gzipis = new GZIPInputStream(blob.getBinaryStream());
        return new InputStreamReader(gzipis);
    }

    public static void updateGzippedBlobFromInputStream(Blob blob, InputStream is) throws IOException, SQLException {
        try (BufferedInputStream bis = new BufferedInputStream(is);
             GZIPOutputStream gzipos = new GZIPOutputStream(blob.setBinaryStream(1L));
             BufferedOutputStream bos = new BufferedOutputStream(gzipos);){
            IoUtil.copy(bis, bos);
        }
    }

    public static Blob createGzippedBlobFromInputStream(Connection conn, InputStream is) throws IOException, SQLException {
        Blob blob = conn.createBlob();
        BlobUtil.updateGzippedBlobFromInputStream(blob, is);
        return blob;
    }

    public static Blob createGzippedBlobFromFile(Connection conn, Path filePath) throws IOException, SQLException {
        Blob blob = conn.createBlob();
        BlobUtil.createGzippedBlobFromFile(filePath, blob);
        return blob;
    }

    public static void createGzippedBlobFromFile(Path filePath, Blob blob) throws IOException, SQLException {
        try (GZIPOutputStream gzip = new GZIPOutputStream(blob.setBinaryStream(1L));){
            Files.copy(filePath, gzip);
        }
    }

    public static void lobToFile(Blob blob, Path targetPath) throws SQLException, IOException {
        try (GZIPInputStream gzipis = new GZIPInputStream(blob.getBinaryStream());){
            Files.copy(gzipis, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void lobToFile(Blob blob, File targetFile) throws SQLException, IOException {
        BlobUtil.lobToFile(blob, targetFile.toPath());
    }

    public static void lobToFile(Blob blob, String targetFileName) throws SQLException, IOException {
        BlobUtil.lobToFile(blob, Paths.get(targetFileName, new String[0]));
    }

    public static void lobToFile(Blob blob, String targetFileName, String xslFileName, Map<String, Object> xslParameters) throws SQLException, IOException, TransformerException {
        File xslFile = new File(xslFileName);
        try (GZIPInputStream inputStream = new GZIPInputStream(blob.getBinaryStream());
             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
             FileOutputStream fos = new FileOutputStream(targetFileName);
             OutputStreamWriter osWriter = new OutputStreamWriter(fos);
             BufferedWriter writer = new BufferedWriter(osWriter);){
            XslUtil.transform(bufferedInputStream, (Writer)writer, xslFile, xslParameters, null);
        }
    }

    public static void lobToFile(Blob blob, Writer writer, File xslFile, Map<String, Object> xslParameters) throws SQLException, IOException, TransformerException {
        try (GZIPInputStream inputStream = new GZIPInputStream(blob.getBinaryStream());
             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            XslUtil.transform(bufferedInputStream, writer, xslFile, xslParameters, null);
        }
    }

    public static void lobToFile(Blob blob, Writer writer) throws SQLException, IOException {
        try (InputStreamReader isReader = BlobUtil.getGzippedBlobInputStreamReader(blob);
             BufferedReader reader = new BufferedReader(isReader);){
            IoUtil.copy((Reader)reader, writer);
        }
    }

    public static void fileToLob(File file, Blob blob) throws IOException, SQLException {
        BlobUtil.createGzippedBlobFromFile(file.toPath(), blob);
    }

    private BlobUtil() {
    }
}

