/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.sql;

import com.cadwin.basic.io.IoUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobUtil {
    public static String lobToString(Clob clob) throws SQLException, IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());){
            IoUtil.copy((Reader)bufferedReader, sb);
        }
        return sb.toString();
    }

    public static void lobToFile(Clob clob, Path targetPath) throws SQLException, IOException {
        try (BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
             FileOutputStream fileOutputStream = new FileOutputStream(targetPath.toFile());
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
             BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);){
            IoUtil.copy((Reader)bufferedReader, bufferedWriter);
        }
    }

    public static void fileToLob(Path sourceFilePath, Clob clob) throws IOException, SQLException {
        try (FileReader fileReader = new FileReader(sourceFilePath.toFile());){
            ClobUtil.readerToLob(fileReader, clob);
        }
    }

    public static void readerToLob(Reader reader, Clob clob) throws IOException, SQLException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);
             BufferedWriter bufferedWriter = new BufferedWriter(clob.setCharacterStream(1L));){
            IoUtil.copy((Reader)bufferedReader, bufferedWriter);
        }
    }

    private ClobUtil() {
    }
}

