/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamedParameterStatement
implements AutoCloseable {
    private static final String REGEXP = "(?<!')(:\\w+)(?!')";
    private static final Pattern PATTERN = Pattern.compile("(?<!')(:\\w+)(?!')");
    private final Map<String, List<Integer>> nameParamerPos;
    private final PreparedStatement pstmt;

    public NamedParameterStatement(Connection conn, String stmt) throws SQLException {
        Matcher m = PATTERN.matcher(stmt);
        this.nameParamerPos = new HashMap<String, List<Integer>>();
        int paramNo = 1;
        while (m.find()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                String paramName = m.group(i);
                this.nameParamerPos.computeIfAbsent(paramName, key -> new ArrayList()).add(paramNo);
            }
            ++paramNo;
        }
        String pstmtTxt = m.replaceAll("?");
        this.pstmt = conn.prepareStatement(pstmtTxt);
    }

    public void setString(String name, String value) throws SQLException {
        List<Integer> indices = this.nameParamerPos.get(name);
        for (int index : indices) {
            this.pstmt.setString(index, value);
        }
    }

    public void setBigDecimal(String name, BigDecimal value) throws SQLException {
        List<Integer> indices = this.nameParamerPos.get(name);
        for (int index : indices) {
            this.pstmt.setBigDecimal(index, value);
        }
    }

    public void setBigInteger(String name, BigInteger value) throws SQLException {
        List<Integer> indices = this.nameParamerPos.get(name);
        for (int index : indices) {
            this.pstmt.setBigDecimal(index, new BigDecimal(value));
        }
    }

    public PreparedStatement getStatement() {
        return this.pstmt;
    }

    @Override
    public void close() throws Exception {
        if (Objects.nonNull(this.pstmt)) {
            this.pstmt.close();
        }
    }
}

