/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomWriter {
    private static final StringBuilder sb = new StringBuilder();
    private static final String[] knownEntities = new String[]{"gt", "amp", "lt"};

    private DomWriter() {
    }

    public static void write(Element root, OutputStream out) throws IOException {
        OutputStreamWriter wri = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        wri.write("<?xml version=\"1.0\" encoding=\"" + StandardCharsets.UTF_8.name() + "\"?>\n");
        DomWriter.write(root, wri);
        wri.write("\n");
        ((Writer)wri).flush();
    }

    public static void write(Element element, Writer out) throws IOException {
        element.normalize();
        out.write("<");
        out.write(element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        if (attrs.getLength() != 0) {
            Attr first = (Attr)attrs.item(0);
            out.write(" ");
            out.write(first.getName());
            out.write("=");
            String value = first.getValue();
            out.write(DomWriter.getAttribute(value));
            for (int i = 1; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                out.write(" ");
                out.write(attr.getName());
                out.write("=");
                String other = attr.getValue();
                out.write(DomWriter.getAttribute(other));
            }
        }
        if (!element.hasChildNodes()) {
            out.write("/");
        }
        out.write(">");
        NodeList children = element.getChildNodes();
        block9: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    DomWriter.write((Element)child, out);
                    continue block9;
                }
                case 3: {
                    out.write(DomWriter.encode(child.getNodeValue()));
                    continue block9;
                }
                case 4: {
                    out.write("<![CDATA[");
                    out.write(DomWriter.encodeData(((Text)child).getData()));
                    out.write("]]>");
                    continue block9;
                }
                case 5: {
                    out.write(38);
                    out.write(child.getNodeName());
                    out.write(59);
                    continue block9;
                }
                case 7: {
                    out.write("<?");
                    out.write(child.getNodeName());
                    String data = child.getNodeValue();
                    if (data != null && !data.isEmpty()) {
                        out.write(32);
                        out.write(data);
                    }
                    out.write("?>");
                    continue block9;
                }
                case 8: {
                    out.write("<!--");
                    out.write(child.getNodeValue());
                    out.write("-->");
                    continue block9;
                }
            }
        }
        if (element.hasChildNodes()) {
            out.write("</");
            out.write(element.getTagName());
            out.write(">");
        }
        out.flush();
    }

    public static String encode(String value) {
        sb.setLength(0);
        block5: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    int nextSemi = value.indexOf(";", i);
                    if (nextSemi < 0 || !DomWriter.isReference(value.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        continue block5;
                    }
                    sb.append('&');
                    continue block5;
                }
                default: {
                    if (!DomWriter.isLegalCharacter(c)) continue block5;
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String encodeAttr(String value) {
        sb.setLength(0);
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                case '&': {
                    int nextSemi = value.indexOf(";", i);
                    if (nextSemi < 0 || !DomWriter.isReference(value.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        continue block6;
                    }
                    sb.append('&');
                    continue block6;
                }
                default: {
                    if (!DomWriter.isLegalCharacter(c)) continue block6;
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String encodeData(String value) {
        sb.setLength(0);
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!DomWriter.isLegalCharacter(c)) continue;
            sb.append(c);
        }
        String result = sb.toString();
        int cdEnd = result.indexOf("]]>");
        while (cdEnd != -1) {
            sb.setLength(cdEnd);
            sb.append("&#x5d;&#x5d;&gt;").append(result.substring(cdEnd + 3));
            result = sb.toString();
            cdEnd = result.indexOf("]]>");
        }
        return result;
    }

    public static boolean isReference(String ent) {
        boolean result;
        if (ent.charAt(0) == '&' && ent.charAt(ent.length() - 1) == ';') {
            if (ent.charAt(1) == '#') {
                int beginIndex;
                int radix;
                if (ent.charAt(2) == 'x') {
                    radix = 16;
                    beginIndex = 3;
                } else {
                    radix = 10;
                    beginIndex = 2;
                }
                try {
                    Integer.parseInt(ent.substring(beginIndex, ent.length() - 1), radix);
                    result = true;
                }
                catch (NumberFormatException nfe) {
                    result = false;
                }
            } else {
                String name = ent.substring(1, ent.length() - 1);
                result = Arrays.stream(knownEntities).anyMatch(name::equals);
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }

    private static String getAttribute(String value) {
        if (value.indexOf(34) == -1) {
            return "\"" + DomWriter.encode(value) + "\"";
        }
        if (value.indexOf(39) == -1) {
            return "'" + DomWriter.encode(value) + "'";
        }
        return "\"" + DomWriter.encodeAttr(value) + "\"";
    }
}

