/*
 * Decompiled with CFR 0.152.
 */
package com.cadwin.basic.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XslUtil {
    public static void transform(InputStream inputStream, Writer targetWriter, File xsltFilterFile, Map<String, ?> map, ErrorListener errorListener) throws IOException, TransformerException {
        XslUtil.transform((Source)new StreamSource(inputStream), targetWriter, xsltFilterFile, map, errorListener);
    }

    public static void transform(File sourceFile, File destinationFile, File xsltFilterFile, Map<String, ?> map, ErrorListener errorListener) throws IOException, TransformerException {
        try (FileOutputStream fos = new FileOutputStream(destinationFile);
             OutputStreamWriter targetFileWriter = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            StreamSource source = new StreamSource(sourceFile);
            XslUtil.transform((Source)source, (Writer)targetFileWriter, xsltFilterFile, map, errorListener);
        }
        catch (IOException | TransformerException e) {
            Files.delete(destinationFile.toPath());
            throw e;
        }
    }

    private static void transform(Source source, Writer targetWriter, File xsltFilterFile, Map<String, ?> map, ErrorListener errorListener) throws IOException, TransformerException {
        TransformerFactory fabriqueT = TransformerFactory.newInstance();
        StreamSource styleSource = new StreamSource(xsltFilterFile);
        Transformer transformer = fabriqueT.newTransformer(styleSource);
        if (errorListener != null) {
            transformer.setErrorListener(errorListener);
        }
        if (map != null) {
            map.entrySet().forEach(entry -> transformer.setParameter((String)entry.getKey(), entry.getValue()));
        }
        try (BufferedWriter bw = new BufferedWriter(targetWriter);){
            StreamResult result = new StreamResult(bw);
            transformer.transform(source, result);
        }
    }

    private static void transform(Source inputSource, Writer targetWriter, File[] xsltFilterFiles, Map<String, ?> map, ErrorListener errorListener) throws IOException, TransformerException {
        TransformerFactory fabriqueT = TransformerFactory.newInstance();
        Source source = inputSource;
        for (int i = 0; i < xsltFilterFiles.length; ++i) {
            StreamSource styleSource = new StreamSource(xsltFilterFiles[i]);
            Transformer transformer = fabriqueT.newTransformer(styleSource);
            if (errorListener != null) {
                transformer.setErrorListener(errorListener);
            }
            if (map != null) {
                map.entrySet().forEach(entry -> transformer.setParameter((String)entry.getKey(), entry.getValue()));
            }
            if (i == xsltFilterFiles.length - 1) {
                try (BufferedWriter bw = new BufferedWriter(targetWriter);){
                    StreamResult result = new StreamResult(bw);
                    transformer.transform(source, result);
                    continue;
                }
            }
            DOMResult domResult = new DOMResult();
            transformer.transform(source, domResult);
            source = new DOMSource(domResult.getNode());
        }
    }

    public static void transform(File sourceFile, File destinationFile, File[] xsltFilterFiles, Map<String, ?> map, ErrorListener errorListener) throws IOException, TransformerException {
        try (FileOutputStream fos = new FileOutputStream(destinationFile);
             OutputStreamWriter targetFileWriter = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            StreamSource source = new StreamSource(sourceFile);
            XslUtil.transform((Source)source, (Writer)targetFileWriter, xsltFilterFiles, map, errorListener);
        }
        catch (IOException | TransformerException e) {
            Files.delete(destinationFile.toPath());
            throw e;
        }
    }

    private XslUtil() {
    }
}

