/*
 * Decompiled with CFR 0.152.
 */
package db.manager.datapump;

import db.manager.datapump.DatapumpFileActionFactory;
import db.manager.datapump.DatapumpFileActionIF;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.log4j.Logger;

class DatapumpFileSystemAction
implements DatapumpFileActionIF {
    private static final Logger LOGGER = Logger.getLogger(DatapumpFileActionFactory.class);
    private final Path serverSideFile;

    public DatapumpFileSystemAction(Path serverSideFile) {
        this.serverSideFile = serverSideFile;
        LOGGER.debug((Object)String.format("New instance of FileSystemdatapumpAction(serverSideFile %s) created", serverSideFile.toString()));
    }

    @Override
    public void sendToServer(Path source) throws IOException {
        Files.copy(source, this.serverSideFile, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void getFromServer(Path target) throws IOException {
        Files.copy(this.serverSideFile, target, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void deleteFromServer() throws IOException {
        Files.deleteIfExists(this.serverSideFile);
    }
}

