/*
 * Decompiled with CFR 0.152.
 */
package db.manager.datapump;

import com.cadwin.basic.ftp.FTPUtil;
import db.manager.datapump.DatapumpFileActionIF;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.log4j.Logger;

class DatapumpFtpAction
implements DatapumpFileActionIF {
    private static final Logger LOGGER = Logger.getLogger(DatapumpFtpAction.class);
    private final String ftpFolderURI;

    DatapumpFtpAction(String username, String password, String host, String serverSideFolder, String filename) {
        this(FTPUtil.buildURL((String)username, (String)password, (String)host, (String)serverSideFolder), filename);
    }

    DatapumpFtpAction(String ftpFolderURI, String filename) {
        this.ftpFolderURI = ftpFolderURI + "/" + filename;
        LOGGER.debug((Object)String.format("New instance of %s(%s, %s)", DatapumpFtpAction.class.getName(), ftpFolderURI, filename));
    }

    @Override
    public void sendToServer(Path source) throws IOException {
        FTPUtil.put((String)this.ftpFolderURI, (Path)source);
    }

    @Override
    public void getFromServer(Path target) throws IOException {
        FTPUtil.get((String)this.ftpFolderURI, (Path)target);
    }

    @Override
    public void deleteFromServer() throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream("".getBytes());){
            FTPUtil.put((String)this.ftpFolderURI, (InputStream)is);
        }
    }
}

