/*
 * Decompiled with CFR 0.152.
 */
package db.manager.datasource;

import db.manager.constant.database.DatabaseInstance;
import db.manager.constant.database.XmDbDef;
import db.manager.datasource.DataSourceUtil;
import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import org.apache.log4j.Logger;

public class DataSourceFactory {
    private static final Logger LOGGER = Logger.getLogger(DataSourceFactory.class);

    private static DataSource getDataSource(DatabaseInstance databaseInstance, String username, String password) throws SQLException {
        OracleDataSource datasource = new OracleDataSource();
        String jdbcURL = DataSourceUtil.buildJDBCURL(databaseInstance);
        LOGGER.debug((Object)String.format("Datasource created %s, %s", jdbcURL, username));
        datasource.setURL(jdbcURL);
        datasource.setUser(username);
        datasource.setPassword(password);
        return datasource;
    }

    public static DataSource getDataSourceSystem(DatabaseInstance databaseInstance) throws SQLException {
        return DataSourceFactory.getDataSource(databaseInstance, databaseInstance.getSystem(), databaseInstance.getSystemPassword());
    }

    public static DataSource getDataSourceUser(XmDbDef xmDbDef) throws SQLException {
        return DataSourceFactory.getDataSource(xmDbDef, xmDbDef.getSchema(), xmDbDef.getSchemaPassword());
    }

    private DataSourceFactory() {
    }
}

