/*
 * Decompiled with CFR 0.152.
 */
package db.manager.datasource;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class DbmsOutput
implements AutoCloseable {
    private final CallableStatement enableStmt;
    private final CallableStatement disableStmt;
    private final CallableStatement showStmt;

    public DbmsOutput(Connection c) throws SQLException {
        this.enableStmt = c.prepareCall("{call sys.dbms_output.enable(?)}");
        this.disableStmt = c.prepareCall("{call sys.dbms_output.disable()}");
        this.showStmt = c.prepareCall("{call sys.dbms_output.get_line(?,?)}");
    }

    public void enable(int size) throws SQLException {
        this.enableStmt.setInt(1, size);
        this.enableStmt.execute();
    }

    public void disable() throws SQLException {
        this.disableStmt.execute();
    }

    public String getLines() throws SQLException {
        StringBuilder lines = new StringBuilder();
        this.showStmt.registerOutParameter(1, 12);
        this.showStmt.registerOutParameter(2, 2);
        int status = 0;
        do {
            this.showStmt.execute();
            String line = this.showStmt.getString(1);
            lines.append(line);
            lines.append(System.lineSeparator());
        } while ((status = this.showStmt.getInt(2)) == 0);
        return lines.toString();
    }

    @Override
    public void close() throws SQLException {
        this.enableStmt.close();
        this.disableStmt.close();
        this.showStmt.close();
    }
}

