/*
 * Decompiled with CFR 0.152.
 */
package db.manager.exec.delete;

import db.manager.datasource.DataSourceFactory;
import db.manager.exec.delete.DeleteActionDef;
import db.manager.files.FileUtil;
import db.manager.queries.SqlUtil;
import db.manager.strings.StringUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DeleteService {
    private static final Logger LOGGER = Logger.getLogger(DeleteService.class);

    public static void delete(DeleteActionDef deleteActionDef) {
        String action = "delete";
        deleteActionDef.getObserver().reset();
        deleteActionDef.getObserver().start("delete");
        try {
            DeleteService.dropSchemaStep(deleteActionDef);
            DeleteService.deleteDatabaseFolderStep(deleteActionDef);
            deleteActionDef.getObserver().end();
        }
        catch (IOException | SQLException e) {
            deleteActionDef.getObserver().error("delete failure", e);
        }
    }

    private static void dropSchemaStep(DeleteActionDef deleteActionDef) throws SQLException {
        String action = "drop schema";
        deleteActionDef.getObserver().start("drop schema");
        DataSource ds = DataSourceFactory.getDataSourceSystem(deleteActionDef.getXmDbDef());
        try (Connection conn = ds.getConnection();){
            SqlUtil.dropUser(deleteActionDef.getObserver(), conn, deleteActionDef.getXmDbDef().getSchema());
            if (!StringUtil.isEmpty(deleteActionDef.getUserRole())) {
                SqlUtil.dropRole(deleteActionDef.getObserver(), conn, deleteActionDef.getUserRole());
            }
            deleteActionDef.getObserver().end();
        }
    }

    private static void deleteDatabaseFolderStep(DeleteActionDef deleteActionDef) throws IOException {
        String action = "delete database folder";
        deleteActionDef.getObserver().start("delete database folder");
        String databaseFolder = deleteActionDef.getDatabaseFolderPath();
        String deletingMsg = String.format("deleting %s", databaseFolder);
        LOGGER.debug((Object)deletingMsg);
        deleteActionDef.getObserver().addContentWithLineBreak(deletingMsg);
        File f = new File(databaseFolder);
        if (f.exists()) {
            FileUtil.removeDirectory(f.toPath(), false);
        }
        deleteActionDef.getObserver().end();
    }

    private DeleteService() {
    }
}

