/*
 * Decompiled with CFR 0.152.
 */
package db.manager.exec.restore;

import db.manager.constant.database.XmDbDef;
import db.manager.datapump.DatapumpFileActionFactory;
import db.manager.datapump.DatapumpFileActionIF;
import db.manager.datasource.DataSourceFactory;
import db.manager.datasource.DataSourceUtil;
import db.manager.datasource.DbmsOutput;
import db.manager.exec.observer.ExecutionObserver;
import db.manager.exec.restore.RestoreActionDef;
import db.manager.exec.tools.SQLUtil;
import db.manager.files.FileUtil;
import db.manager.queries.SqlUtil;
import db.manager.resource.ResourceUtil;
import db.manager.strings.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class RestoreService {
    private static final Logger LOGGER = Logger.getLogger(RestoreService.class);
    private static final String MAINTENANCE_MODE_PROP = "MAINTENANCE_MODE";
    private static final String DB_INFOS_ENTRY_NAME = "configs/db_infos.xml";
    private static final String DB_INFOS_DBNAME_PATTERN = "%s (%s@%s)";
    private static final String[] PREFIX_LIST = new String[]{"topfolder", "/support", "support"};
    private static final String UNZIP_STEP_LOG_FORMAT = "%-10s %s";

    public static void executeUpdate(ExecutionObserver observer, Connection connection, String query, String actionMsg) {
        try (PreparedStatement ps = connection.prepareStatement(query);){
            observer.addContentWithLineBreak(query);
            int rows = ps.executeUpdate();
            if (rows > 0) {
                observer.addContentWithLineBreak(String.format("%s row(s) %s.", rows, actionMsg));
            }
            observer.addLineBreak();
        }
        catch (SQLException sqle) {
            observer.error("executeUpdate failure", sqle);
        }
    }

    public static Properties readInfosFile(File databaseFolder) throws IOException {
        Properties properties = new Properties();
        File importExportDirectory = new File(databaseFolder, "import-export");
        File infosFile = new File(importExportDirectory, "infos.txt");
        try (FileInputStream infosIs = new FileInputStream(infosFile);){
            String infosFileS = FileUtil.readFile(infosIs);
            if (infosFileS.contains(",")) {
                String[] sTab;
                for (String s : sTab = infosFileS.split(",")) {
                    properties.put(s.split("=")[0], s.split("=")[1]);
                }
            } else {
                properties.loadFromXML(infosIs);
            }
        }
        return properties;
    }

    private static String dropPrefix(String entryName) {
        String result = entryName;
        for (String prefix : PREFIX_LIST) {
            if (!entryName.startsWith(prefix + "/")) continue;
            result = entryName.substring(prefix.length());
        }
        return result;
    }

    private static boolean isRoleDefined(RestoreActionDef restoreActionDef) {
        String role = restoreActionDef.getUserRole();
        return !StringUtil.isEmpty(role);
    }

    private static void restoreDpDumpOnly(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.unzipStep(restoreActionDef);
            RestoreService.import1Step(restoreActionDef);
            RestoreService.import2CopyStep(restoreActionDef);
            RestoreService.import2PostCopyStep(restoreActionDef);
            RestoreService.import3Step(restoreActionDef);
            RestoreService.deleteDatabaseFolderStep(restoreActionDef);
        }
        catch (IOException | SQLException ex) {
            restoreActionDef.setActionFailed();
            restoreActionDef.getObserver().error("restore failure", ex);
        }
    }

    private static void restoreAll(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.dropSchemaStep(restoreActionDef);
            RestoreService.deleteDatabaseFolderStep(restoreActionDef);
            RestoreService.unzipStep(restoreActionDef);
            RestoreService.import1Step(restoreActionDef);
            RestoreService.import2CopyStep(restoreActionDef);
            RestoreService.import2PostCopyStep(restoreActionDef);
            RestoreService.import3Step(restoreActionDef);
            RestoreService.updateCdmInfos(restoreActionDef);
            RestoreService.writeDbInfosStep(restoreActionDef);
            RestoreService.revalidStep(restoreActionDef);
            RestoreService.grantAllStep(restoreActionDef);
            RestoreService.reset4SrStep(restoreActionDef);
            RestoreService.userScriptStep(restoreActionDef);
            RestoreService.analyseStep(restoreActionDef);
            restoreActionDef.getObserver().end();
        }
        catch (IOException | SQLException ex) {
            restoreActionDef.setActionFailed();
            restoreActionDef.getObserver().error("restore failure", ex);
        }
    }

    public static void restore(RestoreActionDef restoreActionDef) {
        String action = "restore";
        restoreActionDef.getObserver().start("restore");
        if (restoreActionDef.isDpdumpOnly()) {
            RestoreService.restoreDpDumpOnly(restoreActionDef);
        } else {
            RestoreService.restoreAll(restoreActionDef);
        }
    }

    public static void dropSchema(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.dropSchemaStep(restoreActionDef);
        }
        catch (SQLException sqle) {
            restoreActionDef.getObserver().error("drop schema failure", sqle);
        }
    }

    public static void deleteDatabaseFolder(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.deleteDatabaseFolderStep(restoreActionDef);
        }
        catch (IOException ioe) {
            restoreActionDef.getObserver().error("delete database folder failure", ioe);
        }
    }

    public static void unzip(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.unzipStep(restoreActionDef);
        }
        catch (IOException ioe) {
            restoreActionDef.getObserver().error("unzip database failure", ioe);
        }
    }

    public static void import1(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.import1Step(restoreActionDef);
        }
        catch (IOException | SQLException e) {
            restoreActionDef.getObserver().error("import1 database failure", e);
        }
    }

    public static void import2(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.import2CopyStep(restoreActionDef);
            RestoreService.import2PostCopyStep(restoreActionDef);
        }
        catch (IOException | SQLException e) {
            restoreActionDef.getObserver().error("import2 database failure", e);
        }
    }

    public static void import3(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.import3Step(restoreActionDef);
        }
        catch (IOException | SQLException e) {
            restoreActionDef.getObserver().error("import3 database failure", e);
        }
    }

    public static void updateCdmInfos(RestoreActionDef restoreActionDef) {
        Map<String, String> cdmInfosValues = restoreActionDef.getCdmInfos();
        if (Objects.nonNull(cdmInfosValues)) {
            try {
                DataSource ds = DataSourceFactory.getDataSourceUser(restoreActionDef.getXmDbDef());
                try (Connection conn = ds.getConnection();){
                    for (Map.Entry<String, String> cdmInfosValuesEntry : cdmInfosValues.entrySet()) {
                        String paramName = cdmInfosValuesEntry.getKey();
                        String paramVal = cdmInfosValuesEntry.getValue();
                        SqlUtil.setCdmInfosParam(conn, paramName, paramVal);
                        restoreActionDef.getObserver().addContentWithLineBreak(String.format("CDM_INFOS : %s set to %s", paramName, paramVal));
                    }
                    if (!RestoreService.isRoleDefined(restoreActionDef)) {
                        SqlUtil.deleteFromCdmInfos(conn, "ROLE");
                        restoreActionDef.getObserver().addContentWithLineBreak("Role deleted from CDM_INFOS");
                    } else {
                        SqlUtil.setCdmInfosParam(conn, "ROLE", restoreActionDef.getUserRole());
                        restoreActionDef.getObserver().addContentWithLineBreak(String.format("Role %s added into CDM_INFOS", restoreActionDef.getUserRole()));
                    }
                }
            }
            catch (SQLException ex) {
                restoreActionDef.getObserver().error("updateCdmInfos failure", ex);
            }
            restoreActionDef.getObserver().addContentWithLineBreak(String.format("%d line%s updated / added in CDM_INFOS", cdmInfosValues.size(), cdmInfosValues.size() > 0 ? "s" : ""));
        }
    }

    public static void writeDbInfos(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.writeDbInfosStep(restoreActionDef);
        }
        catch (IOException | SQLException e) {
            restoreActionDef.getObserver().error("writeDbInfos database failure", e);
        }
    }

    public static void revalid(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.revalidStep(restoreActionDef);
        }
        catch (IOException | SQLException e) {
            restoreActionDef.getObserver().error("revalid database failure", e);
        }
    }

    public static void grantAll(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.grantAllStep(restoreActionDef);
        }
        catch (IOException | SQLException e) {
            restoreActionDef.getObserver().error("grantAll database failure", e);
        }
    }

    public static void reset4Sr(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.reset4SrStep(restoreActionDef);
        }
        catch (IOException | SQLException e) {
            restoreActionDef.getObserver().error("reset4Sr database failure", e);
        }
    }

    public static void analyse(RestoreActionDef restoreActionDef) {
        try {
            RestoreService.analyseStep(restoreActionDef);
        }
        catch (SQLException sqle) {
            restoreActionDef.getObserver().error("analyse database failure", sqle);
        }
    }

    private static void dropSchemaStep(RestoreActionDef restoreActionDef) throws SQLException {
        String action = "drop schema";
        restoreActionDef.getObserver().start("drop schema");
        DataSource ds = DataSourceFactory.getDataSourceSystem(restoreActionDef.getXmDbDef());
        try (Connection c = ds.getConnection();){
            SqlUtil.dropUser(restoreActionDef.getObserver(), c, restoreActionDef.getXmDbDef().getSchema());
            if (RestoreService.isRoleDefined(restoreActionDef)) {
                SqlUtil.dropRole(restoreActionDef.getObserver(), c, restoreActionDef.getUserRole());
            }
            restoreActionDef.getObserver().end();
        }
    }

    private static void deleteDatabaseFolderStep(RestoreActionDef restoreActionDef) throws IOException {
        String action = "delete database folder";
        restoreActionDef.getObserver().start("delete database folder");
        String databaseFolder = restoreActionDef.getDatabaseFolderPath();
        String deletingMsg = String.format("deleting %s", databaseFolder);
        LOGGER.debug((Object)deletingMsg);
        restoreActionDef.getObserver().addContentWithLineBreak(deletingMsg);
        File f = new File(databaseFolder);
        if (f.exists()) {
            FileUtil.removeDirectory(f.toPath(), restoreActionDef.getDeleteDatabaseFolder());
        }
        restoreActionDef.getObserver().end();
    }

    private static ZipEntry getDbInfosEntry(ZipFile zf) {
        ZipEntry result = zf.getEntry(DB_INFOS_ENTRY_NAME);
        for (int i = 0; result == null && i < PREFIX_LIST.length; ++i) {
            String entryName = String.format("%s/%s", PREFIX_LIST[i], DB_INFOS_ENTRY_NAME);
            result = zf.getEntry(entryName);
        }
        return result;
    }

    private static Properties readDbInfosFromZip(File zipFile) throws IOException {
        Properties p = new Properties();
        ZipFile zf = new ZipFile(zipFile);
        ZipEntry e = RestoreService.getDbInfosEntry(zf);
        if (e == null) {
            throw new IOException(String.format("db_infos.xml not found in zipfile %s", zipFile.getName()));
        }
        try (InputStream is = zf.getInputStream(e);){
            p.loadFromXML(is);
        }
        return p;
    }

    private static void saveDbInfos(Properties dbinfos, File dbInfosXml) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(dbInfosXml);){
            dbinfos.storeToXML(fos, null);
        }
    }

    private static void saveMaintenanceModeDbInfos(RestoreActionDef restoreActionDef) throws IOException {
        File fileToUnzip = new File(restoreActionDef.getZipFilePath());
        Properties dbinfos = RestoreService.readDbInfosFromZip(fileToUnzip);
        dbinfos.put(MAINTENANCE_MODE_PROP, "true");
        Path path = Paths.get(restoreActionDef.getDatabaseFolderPath(), "configs");
        Files.createDirectories(path, new FileAttribute[0]);
        Path dbinfosXml = path.resolve("db_infos.xml");
        RestoreService.saveDbInfos(dbinfos, dbinfosXml.toFile());
    }

    private static void unzipStep(RestoreActionDef restoreActionDef) throws IOException {
        String action = "unzip";
        restoreActionDef.getObserver().start("unzip");
        File databaseFolder = new File(restoreActionDef.getDatabaseFolderPath());
        File fileToUnzip = new File(restoreActionDef.getZipFilePath());
        if (!fileToUnzip.exists()) {
            throw new IOException(String.format("Zip file %s does not exist !!", fileToUnzip.getCanonicalPath()));
        }
        Boolean exists = FileUtil.fileExists(databaseFolder);
        if (exists == null || exists.booleanValue()) {
            throw new IOException(String.format("%s seems to exists (%s)", databaseFolder.getCanonicalPath(), exists == null ? "unknown" : Boolean.toString(exists)));
        }
        boolean created = databaseFolder.mkdirs();
        if (!created) {
            throw new IOException(String.format("Unable to create directory %s", databaseFolder.getCanonicalPath()));
        }
        LOGGER.debug((Object)String.format("Directory %s created", databaseFolder.toString()));
        if (!restoreActionDef.isDpdumpOnly()) {
            RestoreService.saveMaintenanceModeDbInfos(restoreActionDef);
        }
        String unzipMsg = String.format("Processing archive : %s", fileToUnzip.getCanonicalPath());
        restoreActionDef.getObserver().addContentWithLineBreak(unzipMsg);
        restoreActionDef.getObserver().addLineBreak();
        LOGGER.debug((Object)unzipMsg);
        long nbFolders = 0L;
        long nbFiles = 0L;
        long nbEntries = 0L;
        try (ZipFile zipFile = new ZipFile(fileToUnzip, Charset.forName("CP437"));){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ++nbEntries;
                ZipEntry entry = entries.nextElement();
                long lastModified = entry.getTime();
                String entryName = entry.getName();
                if (entryName.equalsIgnoreCase(DB_INFOS_ENTRY_NAME)) {
                    restoreActionDef.getObserver().addContentWithLineBreak(String.format("Skipping entry %s", entryName));
                    continue;
                }
                restoreActionDef.getObserver().addContentWithLineBreak(String.format("(%d/%d) extracting %s ... ", nbEntries, zipFile.size(), entryName));
                File outFile = new File(databaseFolder, RestoreService.dropPrefix(entryName));
                if (entry.isDirectory()) {
                    outFile.mkdirs();
                    LOGGER.trace((Object)String.format("unzipStep - creating folder (%s)", outFile));
                    ++nbFolders;
                } else {
                    File fileFolder = outFile.getParentFile();
                    fileFolder.mkdirs();
                    LOGGER.trace((Object)String.format("unzipStep - creating file (%s)", outFile));
                    try (BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));){
                        Files.copy(bis, outFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        ++nbFiles;
                    }
                }
                if (outFile.setLastModified(lastModified)) continue;
                LOGGER.warn((Object)String.format("unzipStep - setLastModified failed !? (%s)", outFile));
            }
            restoreActionDef.getObserver().addContentWithLineBreak("done");
        }
        restoreActionDef.getObserver().addLineBreak();
        restoreActionDef.getObserver().addContentWithLineBreak(String.format(UNZIP_STEP_LOG_FORMAT, "Compressed", fileToUnzip.length()));
        restoreActionDef.getObserver().addContentWithLineBreak(String.format(UNZIP_STEP_LOG_FORMAT, "Size", FileUtil.sizeDisplayOfFileOrFolder(databaseFolder.toPath())));
        restoreActionDef.getObserver().addContentWithLineBreak(String.format(UNZIP_STEP_LOG_FORMAT, "Folders", nbFolders));
        restoreActionDef.getObserver().addContentWithLineBreak(String.format(UNZIP_STEP_LOG_FORMAT, "Files", nbFiles));
        restoreActionDef.getObserver().addLineBreak();
        String unzippedMsg = String.format("Unzip %s into %s completed.", fileToUnzip.getCanonicalPath(), databaseFolder.getCanonicalPath());
        restoreActionDef.getObserver().addContentWithLineBreak(unzippedMsg);
        LOGGER.debug((Object)unzippedMsg);
        restoreActionDef.getObserver().end();
    }

    private static void replacedParamThenExecuted(Map<String, String> map, RestoreActionDef restoreActionDef, Connection c, String resourcename, String actionMsg) throws IOException {
        try (InputStream is = ResourceUtil.getResourceAsStream(resourcename);){
            List<String> lines = FileUtil.readFileByLine(is);
            Iterator<String> iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line;
                String replacedLine = line = iterator.next();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    replacedLine = replacedLine.replaceAll(entry.getKey(), entry.getValue());
                }
                RestoreService.executeUpdate(restoreActionDef.getObserver(), c, replacedLine, actionMsg);
            }
        }
    }

    private static void import1Step(RestoreActionDef restoreActionDef) throws IOException, SQLException {
        String action = "import1";
        restoreActionDef.getObserver().start("import1");
        Map<String, String> map = Map.ofEntries(Map.entry(":defaultTablespace", restoreActionDef.getDefaultTablespace()), Map.entry(":temporaryTablespace", restoreActionDef.getTemporaryTablespace()), Map.entry(":schema", restoreActionDef.getXmDbDef().getSchema()));
        DataSource systemDS = DataSourceFactory.getDataSourceSystem(restoreActionDef.getXmDbDef());
        try (Connection c = systemDS.getConnection();){
            RestoreService.replacedParamThenExecuted(map, restoreActionDef, c, "i-cmd1.sql", "modified");
            if (RestoreService.isRoleDefined(restoreActionDef)) {
                map.put(":role", restoreActionDef.getUserRole());
                RestoreService.replacedParamThenExecuted(map, restoreActionDef, c, "i-cmd1-role.sql", "modified");
            }
            if (!StringUtil.isEmpty(restoreActionDef.getOracleUser())) {
                map.put(":oracleUser", restoreActionDef.getOracleUser());
                RestoreService.replacedParamThenExecuted(map, restoreActionDef, c, "i-cmd1-oracle_user.sql", "modified");
            }
            if (RestoreService.isRoleDefined(restoreActionDef)) {
                map.put(":oracleUser", !StringUtil.isEmpty(restoreActionDef.getOracleUser()) ? restoreActionDef.getOracleUser() : restoreActionDef.getXmDbDef().getSchema());
                RestoreService.replacedParamThenExecuted(map, restoreActionDef, c, "i-cmd1-oracle_user-role.sql", "modified");
            }
        }
        restoreActionDef.getObserver().end();
    }

    private static void import2CopyStep(RestoreActionDef restoreActionDef) throws IOException, SQLException {
        String action = "import2Copy";
        restoreActionDef.getObserver().start("import2Copy");
        String schemaName = restoreActionDef.getXmDbDef().getSchema();
        File databaseFolder = new File(restoreActionDef.getDatabaseFolderPath());
        File importExportDirectory = new File(databaseFolder, "import-export");
        File dbSideFile = new File(importExportDirectory, "datapump.dmp");
        String copyingMsg = String.format("Copying %s to %s", dbSideFile, restoreActionDef.getDpdumpFolderPath());
        restoreActionDef.getObserver().addContentWithLineBreak(copyingMsg);
        LOGGER.info((Object)copyingMsg);
        String dumpFileName = schemaName + ".dmp";
        DatapumpFileActionIF datapumpFileAction = DatapumpFileActionFactory.getDatapumpAction(restoreActionDef.getDpdumpFolderPath(), dumpFileName);
        datapumpFileAction.sendToServer(dbSideFile.toPath());
        restoreActionDef.getObserver().end();
    }

    private static void import2PostCopyStep(RestoreActionDef restoreActionDef) throws IOException, SQLException {
        String action = "import2PostCopy";
        restoreActionDef.getObserver().start("import2PostCopy");
        String impdpScriptName = "dbassistant4-impdp-tmpl.sql";
        String schemaName = restoreActionDef.getXmDbDef().getSchema();
        File databaseFolder = new File(restoreActionDef.getDatabaseFolderPath());
        File batchFolder = new File(databaseFolder, "batch");
        try (InputStream is = ResourceUtil.getScript(batchFolder, restoreActionDef.isDpdumpOnly(), "dbassistant4-impdp-tmpl.sql");){
            Properties properties = RestoreService.readInfosFile(databaseFolder);
            String sourceSchemaName = properties.getProperty("schema");
            String scriptToExecute = FileUtil.readFile(is);
            scriptToExecute = scriptToExecute.replace("@SRC_SCHEMA@", sourceSchemaName).replace("@TGT_SCHEMA@", schemaName).replace("@HEADER@", "");
            scriptToExecute = scriptToExecute.substring(0, scriptToExecute.toLowerCase().lastIndexOf("end;") + 4);
            String runningScriptMsg = String.format("running %s", "dbassistant4-impdp-tmpl.sql");
            restoreActionDef.getObserver().addLineBreak();
            restoreActionDef.getObserver().addContentWithLineBreak(runningScriptMsg);
            LOGGER.debug((Object)runningScriptMsg);
            DataSource systemDS = DataSourceFactory.getDataSourceSystem(restoreActionDef.getXmDbDef());
            try (Connection c = systemDS.getConnection();
                 DbmsOutput dbmsOutput = new DbmsOutput(c);){
                dbmsOutput.enable(100000);
                try (CallableStatement cs = c.prepareCall(scriptToExecute);){
                    cs.execute();
                    restoreActionDef.getObserver().addLineBreak();
                    restoreActionDef.getObserver().addContentWithLineBreak(dbmsOutput.getLines());
                }
                dbmsOutput.close();
            }
        }
        restoreActionDef.getObserver().addContentWithLineBreak("PL/SQL procedure successfully completed.");
        restoreActionDef.getObserver().addLineBreak();
        restoreActionDef.getObserver().addContentWithLineBreak(String.format("deleting %s", restoreActionDef.getDpdumpFolderPath()));
        String dumpFileName = schemaName + ".dmp";
        DatapumpFileActionIF datapumpFileAction = DatapumpFileActionFactory.getDatapumpAction(restoreActionDef.getDpdumpFolderPath(), dumpFileName);
        datapumpFileAction.deleteFromServer();
        restoreActionDef.getObserver().end();
    }

    private static void import3Step(RestoreActionDef restoreActionDef) throws IOException, SQLException {
        String action = "import3";
        restoreActionDef.getObserver().start("import3");
        File databaseFolder = new File(restoreActionDef.getDatabaseFolderPath());
        Properties properties = RestoreService.readInfosFile(databaseFolder);
        Map<String, String> map = Map.ofEntries(Map.entry(":schema", restoreActionDef.getXmDbDef().getSchema()), Map.entry(":srcSchema", properties.getProperty("schema")));
        DataSource ds = DataSourceFactory.getDataSourceUser(restoreActionDef.getXmDbDef());
        try (Connection cn = ds.getConnection();){
            RestoreService.replacedParamThenExecuted(map, restoreActionDef, cn, "i-cmd3-reset_schema_user.sql", "updated");
            if (!StringUtil.isEmpty(restoreActionDef.getUserRole())) {
                map.put(":role", restoreActionDef.getUserRole());
                RestoreService.replacedParamThenExecuted(map, restoreActionDef, cn, "update-cdm_infos.sql", "updated");
            } else {
                RestoreService.replacedParamThenExecuted(map, restoreActionDef, cn, "delete-cdm_infos.sql", "deleted");
            }
        }
        if (restoreActionDef.isUsersPasswordsRemoval()) {
            cn = ds.getConnection();
            try {
                RestoreService.replacedParamThenExecuted(map, restoreActionDef, cn, "i-cmd3-remove_passwords.sql", "updated");
            }
            finally {
                if (cn != null) {
                    cn.close();
                }
            }
        }
        restoreActionDef.getObserver().end();
    }

    private static String getDisplayedName(XmDbDef xmDbDef) {
        return String.format(DB_INFOS_DBNAME_PATTERN, xmDbDef.getSchema(), xmDbDef.getName(), xmDbDef.getHost());
    }

    private static void writeDbInfosStep(RestoreActionDef restoreActionDef) throws SQLException, IOException {
        String action = "write DbInfos";
        restoreActionDef.getObserver().start("write DbInfos");
        long schemaMajorVersion = 0L;
        DataSource ds = DataSourceFactory.getDataSourceUser(restoreActionDef.getXmDbDef());
        String query = SqlUtil.getQuery("SCHEMA_MAJOR_VERSION");
        try (Connection c = ds.getConnection();
             PreparedStatement ps = c.prepareStatement(query);){
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                schemaMajorVersion = SqlUtil.getLong(rs, "PARAM_VALUE");
            }
        }
        restoreActionDef.getObserver().addContentWithLineBreak(String.format("schema major version : %s", schemaMajorVersion));
        XmDbDef xmDbDef = restoreActionDef.getXmDbDef();
        String sJDBCURL = DataSourceUtil.buildJDBCURL(xmDbDef);
        String oracleConnectionString = DataSourceUtil.getServiceConnectionString(xmDbDef);
        File databaseFolder = new File(restoreActionDef.getDatabaseFolderPath());
        File configsDatabaseFolder = new File(databaseFolder, "configs");
        File dbInfosIni = new File(configsDatabaseFolder, "db_infos.ini");
        if (schemaMajorVersion > 893L) {
            if (dbInfosIni.exists()) {
                dbInfosIni.delete();
            }
        } else {
            try (PrintWriter pw = new PrintWriter(dbInfosIni, "UTF-8");){
                pw.println("ROOT=\"" + xmDbDef.getSchema() + "\"");
                pw.println("SU=\"" + xmDbDef.getSchema() + "\"");
                pw.println("NAME=\"" + RestoreService.getDisplayedName(xmDbDef) + "\"");
                pw.println("JDBC=\"" + sJDBCURL + "\"");
                pw.println("ROLE=\"" + restoreActionDef.getUserRole() + "\"");
                if (!StringUtil.isEmpty(restoreActionDef.getOracleUser())) {
                    pw.println("ORACLE_USER=\"" + restoreActionDef.getOracleUser() + "\"");
                    pw.println("ORACLE_PWD=\"" + restoreActionDef.getOracleUser() + "\"");
                    restoreActionDef.getObserver().addContentWithLineBreak(String.format("%s created.", dbInfosIni.getCanonicalPath()));
                }
                if (restoreActionDef.getDbInfosProperties() != null && !restoreActionDef.getDbInfosProperties().isEmpty()) {
                    restoreActionDef.getDbInfosProperties().entrySet().forEach(entry -> pw.println((String)entry.getKey() + "=\"" + (String)entry.getValue() + "\""));
                }
            }
        }
        File dbInfosXml = new File(configsDatabaseFolder, "db_infos.xml");
        if (schemaMajorVersion <= 891L) {
            if (dbInfosXml.exists()) {
                dbInfosXml.delete();
            }
        } else {
            File importExportDirectory;
            File datapumpFile;
            Properties properties = new Properties();
            if (dbInfosXml.exists()) {
                try (FileInputStream fis = new FileInputStream(dbInfosXml);){
                    properties.loadFromXML(fis);
                }
            }
            properties.setProperty("SCHEMA", xmDbDef.getSchema());
            properties.setProperty("SU", xmDbDef.getSchema());
            properties.setProperty("ROOT", xmDbDef.getSchema());
            properties.setProperty("ALIAS", DataSourceUtil.getServiceConnectionString(xmDbDef));
            properties.setProperty("SQL_NET_CSTRING", oracleConnectionString);
            properties.setProperty("JDBC", sJDBCURL);
            properties.setProperty("NAME", RestoreService.getDisplayedName(xmDbDef));
            if (schemaMajorVersion >= 920L) {
                properties.remove("ROOT");
                properties.remove("SU");
            }
            if ((datapumpFile = new File(importExportDirectory = new File(databaseFolder, "import-export"), "datapump.dmp")).exists()) {
                properties.remove("ALIAS");
            }
            if (RestoreService.isRoleDefined(restoreActionDef)) {
                properties.setProperty("ROLE", restoreActionDef.getUserRole());
            } else if (properties.getProperty("ROLE") != null) {
                properties.remove("ROLE");
            }
            if (StringUtil.isEmpty(restoreActionDef.getOracleUser())) {
                if (properties.getProperty("ORACLE_USER") != null) {
                    properties.remove("ORACLE_USER");
                }
                if (properties.getProperty("ORACLE_PWD") != null) {
                    properties.remove("ORACLE_PWD");
                }
            }
            if (schemaMajorVersion >= 10000L) {
                properties.remove("ALIAS");
                properties.remove("SQL_NET_CSTRING");
            }
            if (restoreActionDef.getDbInfosProperties() != null && !restoreActionDef.getDbInfosProperties().isEmpty()) {
                restoreActionDef.getDbInfosProperties().entrySet().forEach(entry -> properties.setProperty((String)entry.getKey(), (String)entry.getValue()));
            }
            properties.remove(MAINTENANCE_MODE_PROP);
            RestoreService.saveDbInfos(properties, dbInfosXml);
            restoreActionDef.getObserver().addLineBreak();
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                restoreActionDef.getObserver().addContentWithLineBreak(String.format("%-20s %s", key, properties.getProperty(key)));
            }
            restoreActionDef.getObserver().addLineBreak();
            restoreActionDef.getObserver().addContentWithLineBreak(String.format("%s created.", dbInfosXml.getCanonicalPath()));
        }
        restoreActionDef.getObserver().end();
    }

    private static void revalidStep(RestoreActionDef restoreActionDef) throws IOException, SQLException {
        String action = "revalid";
        restoreActionDef.getObserver().start("revalid");
        File databaseFolder = new File(restoreActionDef.getDatabaseFolderPath());
        File scriptFile = new File(new File(databaseFolder, "batch"), "revalid.sql");
        DataSource schemaDs = DataSourceFactory.getDataSourceUser(restoreActionDef.getXmDbDef());
        if (scriptFile.exists()) {
            try (FileInputStream is = new FileInputStream(scriptFile);){
                String scriptToExecute = FileUtil.readFile(is);
                scriptToExecute = scriptToExecute.substring(0, scriptToExecute.toLowerCase().lastIndexOf("end;") + 4);
                String runningScriptMsg = String.format("running %s", scriptFile.getCanonicalPath());
                restoreActionDef.getObserver().addContentWithLineBreak(runningScriptMsg);
                LOGGER.debug((Object)runningScriptMsg);
                try (Connection c = schemaDs.getConnection();
                     CallableStatement cs = c.prepareCall(scriptToExecute);){
                    cs.execute();
                    restoreActionDef.getObserver().addContentWithLineBreak("PL / SQL procedure successfully completed.");
                }
            }
        }
        try (Connection c = schemaDs.getConnection();){
            String invalidObjectsStmt = SqlUtil.getQuery("INVALID_OBJECTS");
            try (PreparedStatement ps = c.prepareStatement(invalidObjectsStmt);){
                restoreActionDef.getObserver().addLineBreak();
                restoreActionDef.getObserver().addContentWithLineBreak("Invalid objects :");
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        restoreActionDef.getObserver().addContentWithLineBreak("no line(s) returned");
                    }
                    while (rs.next()) {
                        String userObjects = String.format("%-20s %-20s %s", rs.getString(1), rs.getString(2), rs.getString(3));
                        restoreActionDef.getObserver().addContentWithLineBreak(userObjects);
                    }
                }
            }
            String missingPackageStmt = SqlUtil.getQuery("MISSING_PACKAGE");
            try (PreparedStatement ps = c.prepareStatement(missingPackageStmt);){
                restoreActionDef.getObserver().addLineBreak();
                restoreActionDef.getObserver().addContentWithLineBreak("Missing package body :");
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        restoreActionDef.getObserver().addContentWithLineBreak("no line(s) returned");
                    }
                    while (rs.next()) {
                        restoreActionDef.getObserver().addContentWithLineBreak(rs.getString(1));
                    }
                }
            }
        }
        restoreActionDef.getObserver().end();
    }

    private static void grantAllStep(RestoreActionDef restoreActionDef) throws IOException, SQLException {
        if (StringUtil.isEmpty(restoreActionDef.getUserRole())) {
            restoreActionDef.getObserver().addContentWithLineBreak("No role defined, grantAll skipped.");
        } else {
            File databaseFolder = new File(restoreActionDef.getDatabaseFolderPath());
            File scriptFile = new File(new File(databaseFolder, "batch"), "grant_all.sql");
            if (scriptFile.exists()) {
                String action = "grant all";
                restoreActionDef.getObserver().start("grant all");
                try (FileInputStream is = new FileInputStream(scriptFile);){
                    String scriptToExecute = FileUtil.readFile(is);
                    scriptToExecute = scriptToExecute.replaceAll("%schema%", restoreActionDef.getXmDbDef().getSchema()).replaceAll("%role%", restoreActionDef.getUserRole());
                    scriptToExecute = scriptToExecute.substring(0, scriptToExecute.toLowerCase().lastIndexOf("end;") + 4);
                    String runningScriptMsg = String.format("running %s", scriptFile.getCanonicalPath());
                    restoreActionDef.getObserver().addContentWithLineBreak(runningScriptMsg);
                    LOGGER.debug((Object)runningScriptMsg);
                    DataSource schemaDs = DataSourceFactory.getDataSourceUser(restoreActionDef.getXmDbDef());
                    try (Connection c = schemaDs.getConnection();
                         CallableStatement cs = c.prepareCall(scriptToExecute);){
                        cs.execute();
                        restoreActionDef.getObserver().addContentWithLineBreak("PL / SQL procedure successfully completed.");
                    }
                    restoreActionDef.getObserver().end();
                }
            }
        }
    }

    private static void reset4SrStep(RestoreActionDef restoreActionDef) throws IOException, SQLException {
        String action = "reset for SR";
        restoreActionDef.getObserver().start("reset for SR");
        File databaseFolder = new File(restoreActionDef.getDatabaseFolderPath());
        File scriptFile = new File(new File(databaseFolder, "batch"), "reset4sr.sql");
        if (scriptFile.exists()) {
            DataSource schemaDatasource = DataSourceFactory.getDataSourceUser(restoreActionDef.getXmDbDef());
            SQLUtil.executeUpdateScriptOnDatasource(restoreActionDef.getObserver(), schemaDatasource, scriptFile);
        }
        restoreActionDef.getObserver().end();
    }

    private static void userScriptStep(RestoreActionDef restoreActionDef) throws IOException, SQLException {
        String userSQLScriptFilePath = restoreActionDef.getUserSQLScriptFilePath();
        if (userSQLScriptFilePath != null) {
            String action = "user script";
            restoreActionDef.getObserver().start("user script");
            File scriptFile = new File(userSQLScriptFilePath);
            if (scriptFile.exists()) {
                DataSource schemaDatasource = DataSourceFactory.getDataSourceUser(restoreActionDef.getXmDbDef());
                SQLUtil.executeScriptOnDatasource(restoreActionDef.getObserver(), schemaDatasource, scriptFile);
            }
            restoreActionDef.getObserver().end();
        }
    }

    private static void analyseStep(RestoreActionDef restoreActionDef) throws SQLException {
        String action = "analyse";
        restoreActionDef.getObserver().start("analyse");
        DataSource systemDatasource = DataSourceFactory.getDataSourceSystem(restoreActionDef.getXmDbDef());
        String stmtToExecute = String.format("dbms_stats.gather_schema_stats ('%s', cascade => true)", restoreActionDef.getXmDbDef().getSchema());
        String callableProc = String.format("begin %s; end;", stmtToExecute);
        try (Connection cn = systemDatasource.getConnection();
             CallableStatement cs = cn.prepareCall(callableProc);){
            restoreActionDef.getObserver().addContentWithLineBreak(String.format("execute %s", stmtToExecute));
            cs.execute();
            restoreActionDef.getObserver().addContentWithLineBreak("PL/SQL procedure successfully completed.");
        }
        restoreActionDef.getObserver().end();
    }

    private RestoreService() {
    }
}

