/*
 * Decompiled with CFR 0.152.
 */
package db.manager.exec.tools;

import db.manager.exec.observer.ExecutionObserver;
import db.manager.files.FileUtil;
import db.manager.strings.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.log4j.Logger;

public class SQLUtil {
    private static final Logger LOGGER = Logger.getLogger(SQLUtil.class);

    public static void executeScriptOnDatasource(ExecutionObserver observer, DataSource ds, File scriptFile) throws IOException, SQLException {
        String runningScriptMsg = String.format("running %s", scriptFile.getCanonicalPath());
        observer.addContentWithLineBreak(runningScriptMsg);
        LOGGER.debug((Object)runningScriptMsg);
        try (FileReader fReader = new FileReader(scriptFile);
             Connection cnx = ds.getConnection();){
            cnx.setAutoCommit(false);
            ScriptRunner sRunner = new ScriptRunner(cnx);
            sRunner.setDelimiter("/");
            sRunner.setStopOnError(true);
            sRunner.runScript((Reader)fReader);
        }
    }

    private static boolean isComment(String stmtLine) {
        return stmtLine.toUpperCase().startsWith("REM") || stmtLine.startsWith("--");
    }

    public static void executeUpdateScriptOnDatasource(ExecutionObserver observer, DataSource ds, File scriptFile) throws IOException, SQLException {
        String runningScriptMsg = String.format("running %s", scriptFile.getCanonicalPath());
        observer.addContentWithLineBreak(runningScriptMsg);
        LOGGER.debug((Object)runningScriptMsg);
        try (FileInputStream is = new FileInputStream(scriptFile);){
            List<String> stmtsToExecute = FileUtil.readFileByLine(is);
            try (Connection cnx = ds.getConnection();){
                for (String stmtLine : stmtsToExecute) {
                    if (StringUtil.isEmpty(stmtLine) || SQLUtil.isComment(stmtLine) || stmtLine.startsWith("commit")) continue;
                    int semicolumnIndex = stmtLine.lastIndexOf(59);
                    if (semicolumnIndex == -1) {
                        String warn = String.format("Statement %s rejected, semicolumn missing at the end", stmtLine);
                        observer.addContentWithLineBreak(warn);
                        LOGGER.warn((Object)warn);
                        continue;
                    }
                    String stmt = stmtLine.substring(0, semicolumnIndex);
                    observer.addLineBreak();
                    observer.addContentWithLineBreak(stmt);
                    PreparedStatement ps = cnx.prepareStatement(stmt);
                    try {
                        int rows = ps.executeUpdate();
                        if (stmt.startsWith("delete")) {
                            observer.addContentWithLineBreak(String.format("%s row(s) deleted.", rows));
                            continue;
                        }
                        if (stmt.startsWith("update")) {
                            observer.addContentWithLineBreak(String.format("%s row(s) updated.", rows));
                            continue;
                        }
                        if (!stmt.startsWith("insert")) continue;
                        observer.addContentWithLineBreak(String.format("%s row(s) inserted.", rows));
                    }
                    finally {
                        if (ps == null) continue;
                        ps.close();
                    }
                }
                observer.addLineBreak();
            }
        }
    }

    private SQLUtil() {
    }
}

