/*
 * Decompiled with CFR 0.152.
 */
package db.manager.queries;

import db.manager.exec.observer.ExecutionObserver;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SqlUtil {
    private static final Logger LOGGER = Logger.getLogger(SqlUtil.class);
    private static final Properties QUERIES = new Properties();

    public static String getQuery(String key) {
        return QUERIES.getProperty(key);
    }

    public static Long getLong(ResultSet rs, String columnName) throws SQLException {
        long l = rs.getLong(columnName);
        return rs.wasNull() ? null : Long.valueOf(l);
    }

    public static BigInteger getBigInteger(ResultSet rs, String columnName) throws SQLException {
        BigInteger bg = rs.getBigDecimal(columnName).toBigInteger();
        return rs.wasNull() ? null : bg;
    }

    public static Double getDouble(ResultSet rs, String columnName) throws SQLException {
        double d = rs.getDouble(columnName);
        return rs.wasNull() ? null : Double.valueOf(d);
    }

    public static void dropUser(ExecutionObserver eo, Connection c, String schema) throws SQLException {
        String sql = SqlUtil.getQuery("DROP_USER").replace("%schema%", schema);
        SqlUtil.execDropStmt(eo, c, sql, 1918);
    }

    public static void dropRole(ExecutionObserver observer, Connection c, String role) throws SQLException {
        String sql = SqlUtil.getQuery("DROP_ROLE").replace("%role%", role);
        SqlUtil.execDropStmt(observer, c, sql, 1919);
    }

    private static void execDropStmt(ExecutionObserver eo, Connection c, String sql, int errorCode) throws SQLException {
        eo.addContentWithLineBreak(sql.trim());
        try (PreparedStatement ps = c.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == errorCode) {
                eo.addContentWithLineBreak(sqle.getMessage());
            }
            throw sqle;
        }
    }

    public static void setCdmInfosParam(Connection conn, String paramName, String paramValue) throws SQLException {
        String sql = SqlUtil.getQuery("SET_CDM_INFOS_PARAM");
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, paramName);
            stmt.setString(2, paramValue);
            stmt.executeUpdate();
        }
    }

    public static void deleteFromCdmInfos(Connection conn, String paramName) throws SQLException {
        String sql = SqlUtil.getQuery("DELETE_FROM_CDM_INFOS");
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, paramName);
            stmt.executeUpdate();
        }
    }

    public static String getDatapumpDir(Connection conn) throws SQLException {
        String result = null;
        String sql = SqlUtil.getQuery("GET_DATA_PUMP_DIR");
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, "DATA_PUMP_DIR");
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    result = rs.getString("DIRECTORY_PATH");
                }
            }
        }
        return result;
    }

    public static String getContainerDatapumpDir(Connection conn, String containerName) throws SQLException {
        String result = null;
        String sql = SqlUtil.getQuery("GET_PDB_DATA_PUMP_DIR");
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, containerName);
            stmt.setString(2, "DATA_PUMP_DIR");
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    result = rs.getString("GUID");
                }
            }
        }
        return result;
    }

    private SqlUtil() {
    }

    static {
        try (InputStream propInputStream = SqlUtil.class.getResourceAsStream("queries.xml");){
            if (propInputStream != null) {
                QUERIES.loadFromXML(propInputStream);
            }
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"load queries file caught exception", (Throwable)ioe);
        }
    }
}

