/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import java.time.LocalDate;
import java.time.Month;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchJavaTimeFieldCodec;

public class ElasticsearchOffsetTimeFieldCodec
extends AbstractElasticsearchJavaTimeFieldCodec<OffsetTime> {
    private static final LocalDate EPOCH_DATE = LocalDate.of(1970, Month.JANUARY, 1);

    public ElasticsearchOffsetTimeFieldCodec(Gson gson, DateTimeFormatter delegate) {
        super(gson, delegate);
    }

    @Override
    protected OffsetTime nullUnsafeParse(String stringValue) {
        return OffsetTime.parse(stringValue, this.formatter);
    }

    @Override
    protected Long nullUnsafeScalar(OffsetTime value) {
        return value.atDate(EPOCH_DATE).toInstant().toEpochMilli();
    }
}

