/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.ReusableLatch;

public class ProducerThread
extends Thread {
    protected final Session session;
    protected final ActionContext context;
    boolean verbose;
    long messageCount = 1000L;
    boolean runIndefinitely = false;
    Destination destination;
    int sleep = 0;
    boolean persistent = true;
    int messageSize = 0;
    int textMessageSize;
    int objectSize;
    long msgTTL = 0L;
    String msgGroupID = null;
    int transactionBatchSize;
    int transactions = 0;
    final AtomicLong sentCount = new AtomicLong(0L);
    String message = null;
    String properties = null;
    String messageText = null;
    String payloadUrl = null;
    byte[] payload = null;
    boolean running = false;
    final ReusableLatch finished = new ReusableLatch(1);
    final ReusableLatch paused = new ReusableLatch(0);

    public ProducerThread(Session session, Destination destination, int threadNr, ActionContext context) {
        super("Producer " + destination.toString() + ", thread=" + threadNr);
        this.destination = destination;
        this.session = session;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MessageProducer producer = null;
        String threadName = Thread.currentThread().getName();
        try {
            producer = this.session.createProducer(this.destination);
            producer.setDeliveryMode(this.persistent ? 2 : 1);
            producer.setTimeToLive(this.msgTTL);
            this.initPayLoad();
            this.running = true;
            this.context.out.println(threadName + " Started to calculate elapsed time ...\n");
            long tStart = System.currentTimeMillis();
            if (this.runIndefinitely) {
                while (this.running) {
                    this.paused.await();
                    this.sendMessage(producer, threadName);
                    this.sentCount.incrementAndGet();
                }
            } else {
                this.sentCount.set(0L);
                while (this.sentCount.get() < this.messageCount && this.running) {
                    this.paused.await();
                    this.sendMessage(producer, threadName);
                    this.sentCount.incrementAndGet();
                }
            }
            try {
                this.session.commit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.context.out.println(threadName + " Produced: " + this.getSentCount() + " messages");
            long tEnd = System.currentTimeMillis();
            long elapsed = (tEnd - tStart) / 1000L;
            this.context.out.println(threadName + " Elapsed time in second : " + elapsed + " s");
            this.context.out.println(threadName + " Elapsed time in milli second : " + (tEnd - tStart) + " milli seconds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.finished != null) {
                this.finished.countDown();
            }
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void sendMessage(MessageProducer producer, String threadName) throws Exception {
        Message message = this.createMessage(this.sentCount.get(), threadName);
        producer.send(message);
        if (this.verbose) {
            this.context.out.println(threadName + " Sent: " + (message instanceof TextMessage ? ((TextMessage)message).getText() : message.getJMSMessageID()));
        }
        if (this.transactionBatchSize > 0 && this.sentCount.get() > 0L && this.sentCount.get() % (long)this.transactionBatchSize == 0L) {
            this.context.out.println(threadName + " Committing transaction: " + this.transactions++);
            this.session.commit();
        }
        if (this.sleep > 0) {
            Thread.sleep(this.sleep);
        }
    }

    private void initPayLoad() {
        if (this.messageSize > 0) {
            this.payload = new byte[this.messageSize];
            for (int i = 0; i < this.payload.length; ++i) {
                this.payload[i] = 46;
            }
        }
    }

    protected Message createMessage(long i, String threadName) throws Exception {
        Object answer;
        if (this.payload != null) {
            answer = this.session.createBytesMessage();
            answer.writeBytes(this.payload);
        } else {
            if (this.textMessageSize > 0 || this.objectSize > 0) {
                if (this.objectSize > 0) {
                    this.textMessageSize = this.objectSize;
                }
                if (this.messageText == null) {
                    String read = this.readInputStream(this.getClass().getResourceAsStream("demo.txt"), this.textMessageSize, i);
                    if (read.length() == this.textMessageSize) {
                        this.messageText = read;
                    } else {
                        StringBuffer buffer = new StringBuffer(read);
                        while (buffer.length() < this.textMessageSize) {
                            buffer.append(read);
                        }
                        this.messageText = buffer.toString();
                    }
                }
            } else {
                this.messageText = this.payloadUrl != null ? this.readInputStream(new URL(this.payloadUrl).openStream(), -1, i) : (this.message != null ? this.message : this.createDefaultMessage(i));
            }
            answer = this.objectSize > 0 ? this.session.createObjectMessage((Serializable)((Object)this.messageText)) : this.session.createTextMessage(this.messageText);
        }
        if (this.msgGroupID != null && !this.msgGroupID.isEmpty()) {
            answer.setStringProperty("JMSXGroupID", this.msgGroupID);
        }
        answer.setLongProperty("count", i);
        answer.setStringProperty("ThreadSent", threadName);
        if (this.properties != null && this.properties.length() != 0) {
            this.applyProperties((Message)answer);
        }
        return answer;
    }

    protected void applyProperties(Message message) throws JMSException {
        JsonArray propertyArray = JsonLoader.readArray((Reader)new StringReader(this.properties));
        block20: for (int j = 0; j < propertyArray.size(); ++j) {
            JsonObject propertyEntry = propertyArray.getJsonObject(j);
            String type = propertyEntry.getString("type");
            String key = propertyEntry.getString("key");
            String value = propertyEntry.getString("value");
            switch (type.toLowerCase()) {
                case "boolean": {
                    message.setBooleanProperty(key, Boolean.parseBoolean(value));
                    continue block20;
                }
                case "int": {
                    message.setIntProperty(key, Integer.parseInt(value));
                    continue block20;
                }
                case "long": {
                    message.setLongProperty(key, Long.parseLong(value));
                    continue block20;
                }
                case "byte": {
                    message.setByteProperty(key, Byte.parseByte(value));
                    continue block20;
                }
                case "short": {
                    message.setShortProperty(key, Short.parseShort(value));
                    continue block20;
                }
                case "float": {
                    message.setFloatProperty(key, Float.parseFloat(value));
                    continue block20;
                }
                case "double": {
                    message.setDoubleProperty(key, Double.parseDouble(value));
                    continue block20;
                }
                case "string": {
                    message.setStringProperty(key, value);
                    continue block20;
                }
                default: {
                    this.context.err.println("Unable to set property: " + key + ". Did not recognize type: " + type + ". Supported types are: boolean, int, long, byte, short, float, double, string.");
                }
            }
        }
    }

    private String readInputStream(InputStream is, int size, long messageNumber) throws IOException {
        String string;
        InputStreamReader reader = new InputStreamReader(is);
        try {
            int count;
            char[] buffer = size > 0 ? new char[size] : new char[1024];
            StringBuilder builder = new StringBuilder();
            while ((count = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, count);
                if (size <= 0) continue;
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                return this.createDefaultMessage(messageNumber);
            }
        }
        reader.close();
        return string;
    }

    private String createDefaultMessage(long messageNumber) {
        return "test message: " + messageNumber;
    }

    public ProducerThread setMessageCount(long messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public int getSleep() {
        return this.sleep;
    }

    public ProducerThread setSleep(int sleep) {
        this.sleep = sleep;
        return this;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public long getSentCount() {
        return this.sentCount.get();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public ProducerThread setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public boolean isRunning() {
        return this.running;
    }

    public ProducerThread setRunning(boolean running) {
        this.running = running;
        return this;
    }

    public long getMsgTTL() {
        return this.msgTTL;
    }

    public ProducerThread setMsgTTL(long msgTTL) {
        this.msgTTL = msgTTL;
        return this;
    }

    public int getTransactionBatchSize() {
        return this.transactionBatchSize;
    }

    public ProducerThread setTransactionBatchSize(int transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
        return this;
    }

    public String getMsgGroupID() {
        return this.msgGroupID;
    }

    public ProducerThread setMsgGroupID(String msgGroupID) {
        this.msgGroupID = msgGroupID;
        return this;
    }

    public int getTextMessageSize() {
        return this.textMessageSize;
    }

    public ProducerThread setTextMessageSize(int textMessageSize) {
        this.textMessageSize = textMessageSize;
        return this;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public ProducerThread setMessageSize(int messageSize) {
        this.messageSize = messageSize;
        return this;
    }

    public ReusableLatch getFinished() {
        return this.finished;
    }

    public ProducerThread setFinished(int value) {
        this.finished.setCount(value);
        return this;
    }

    public String getPayloadUrl() {
        return this.payloadUrl;
    }

    public ProducerThread setPayloadUrl(String payloadUrl) {
        this.payloadUrl = payloadUrl;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ProducerThread setMessage(String message) {
        this.message = message;
        return this;
    }

    public ProducerThread setProperties(String properties) {
        this.properties = properties;
        return this;
    }

    public boolean isRunIndefinitely() {
        return this.runIndefinitely;
    }

    public ProducerThread setRunIndefinitely(boolean runIndefinitely) {
        this.runIndefinitely = runIndefinitely;
        return this;
    }

    public ProducerThread pauseProducer() {
        this.paused.countUp();
        return this;
    }

    public ProducerThread resumeProducer() {
        this.paused.countDown();
        return this;
    }

    public ProducerThread resetCounters() {
        this.sentCount.set(0L);
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ProducerThread setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public int getObjectSize() {
        return this.objectSize;
    }

    public ProducerThread setObjectSize(int objectSize) {
        this.objectSize = objectSize;
        return this;
    }
}

