/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store;

import org.wildfly.common.Assert;
import org.wildfly.security.permission.AbstractNameSetOnlyPermission;
import org.wildfly.security.util.StringEnumeration;
import org.wildfly.security.util.StringMapping;

public class CredentialStorePermission
extends AbstractNameSetOnlyPermission<CredentialStorePermission> {
    private static final long serialVersionUID = 6248622485149435793L;
    private static final StringEnumeration names = StringEnumeration.of("loadCredentialStore", "retrieveCredential", "modifyCredentialStore");
    private static final StringMapping<CredentialStorePermission> mapping = new StringMapping<CredentialStorePermission>(names, CredentialStorePermission::new);
    public static final CredentialStorePermission LOAD_CREDENTIAL_STORE = mapping.getItemById(0);
    public static final CredentialStorePermission RETRIEVE_CREDENTIAL = mapping.getItemById(1);
    public static final CredentialStorePermission MODIFY_CREDENTIAL_STORE = mapping.getItemById(2);
    private static final CredentialStorePermission allPermission = new CredentialStorePermission("*");

    public CredentialStorePermission(String name) {
        super(name, names);
    }

    public CredentialStorePermission(String name, String actions) {
        this(name);
        CredentialStorePermission.requireEmptyActions(actions);
    }

    @Override
    public CredentialStorePermission withName(String name) {
        return CredentialStorePermission.forName(name);
    }

    public static CredentialStorePermission forName(String name) {
        Assert.checkNotNullParam("name", name);
        return name.equals("*") ? allPermission : mapping.getItemByString(name);
    }
}

