/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class TemplatePreferences
extends HashStructureAdapter {
    static String DATA_KEY = "oracle.jdeveloper.template.TemplatePreferences";
    private static String URL_LIST = "urlList";
    private static String URL = "templateDataUrl";

    protected TemplatePreferences(HashStructure hash) {
        super(hash);
    }

    public static TemplatePreferences getInstance(PropertyStorage storage) {
        return new TemplatePreferences(TemplatePreferences.findOrCreate((PropertyStorage)storage, (String)DATA_KEY));
    }

    public List<URL> getTemplateDataURLs() {
        ListStructure list = this.getUrlList();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Object u : list) {
            HashStructure h = (HashStructure)u;
            urls.add(h.getURL(URL));
        }
        return urls;
    }

    public void setTemplateDataURLs(List<URL> urls) {
        ListStructure list = this.getUrlList();
        list.clear();
        for (URL url : urls) {
            this.addTemplateDataURL(url);
        }
    }

    private ListStructure getUrlList() {
        return this._hash.getOrCreateListStructure(URL_LIST);
    }

    public void clearURLs() {
        this.getUrlList().clear();
    }

    public void addTemplateDataURL(URL url) {
        ListStructure list = this.getUrlList();
        HashStructure h = HashStructure.newInstance();
        h.putURL(URL, url);
        list.add((Object)h);
    }

    public void removeTemplateDataURL(URL url) {
        ListStructure list = this.getUrlList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            HashStructure h = (HashStructure)i.next();
            URL u = h.getURL(URL);
            if (!u.toString().equals(url.toString())) continue;
            i.remove();
            return;
        }
    }
}

