/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template.wizard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.ExtensionRegistry;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.util.Assert;
import oracle.jdeveloper.template.AbstractTemplate;
import oracle.jdeveloper.template.ApplicationTemplate;
import oracle.jdeveloper.template.ProjectTemplate;
import oracle.jdeveloper.template.TemplateCustomizationHook;
import oracle.jdeveloper.template.TemplateManager;

public final class GalleryRegistrationHelper {
    private static final String[] APPLICATIONS_GALLERY_PATH = new String[]{"General", "Applications"};
    private static final String[] PROJECTS_GALLERY_PATH = new String[]{"General", "Projects"};
    private static final String[] TEMPLATES_TECH_SCOPE_KEY = new String[]{"General"};
    private static final String WIZARD_CLASS_LOADER_KEY = "oracle.jdeveloper.template";
    private static final String WIZARD_CLASS_KEY = "oracle.jdeveloper.template.wizard.GalleryItemAdapter";
    private static final GalleryRegistrationHelper _instance = new GalleryRegistrationHelper();
    private static final String APP_WIZARD_ICON = "/oracle/javatools/icons/application.png";
    private static final String APP_WIZARD_RULE = "always-enabled";
    private static final String PROJECT_WIZARD_ICON = "/oracle/javatools/icons/project.png";
    private static final String PROJECT_WIZARD_RULE = "context-has-workspace";
    private Boolean _templateDefined = null;
    private ArrayList<ElementInfo> _galleryItems = new ArrayList();

    private GalleryRegistrationHelper() {
    }

    public static GalleryRegistrationHelper getInstance() {
        return _instance;
    }

    public void registerTemplateGalleryItems() {
        this.registerTemplateGalleryItems(GalleryManager.getGalleryManager());
    }

    public void registerTemplateGalleryItems(GalleryManager mgr) {
        this.unregisterGalleryItems(mgr);
        this.registerGalleryItems(mgr);
    }

    private void unregisterGalleryItems(GalleryManager mgr) {
        for (ElementInfo element : this._galleryItems) {
            mgr.unregisterGalleryElement(element);
        }
        this._galleryItems.clear();
    }

    private void registerGalleryItems(GalleryManager galleryMgr) {
        TemplateManager templateMgr = TemplateManager.getInstance();
        ClassLoader classLoader = ExtensionRegistry.getExtensionRegistry().getClassLoader(WIZARD_CLASS_LOADER_KEY);
        this.checkIsDefaultTemplateDefined(templateMgr.getApplicationTemplates());
        this.registerAppTemplates(galleryMgr, templateMgr, classLoader);
        this.registerProjectTemplates(galleryMgr, templateMgr, classLoader);
    }

    private void registerAppTemplates(GalleryManager galleryMgr, TemplateManager templateMgr, ClassLoader classLoader) {
        String icon = APP_WIZARD_ICON;
        for (ApplicationTemplate template : templateMgr.getApplicationTemplates()) {
            if (!template.isValid()) {
                Assert.println((String)(template.getName() + " is not valid a valid template"));
                continue;
            }
            template.setIconFile(APP_WIZARD_ICON);
            for (String folder : this.folders(template)) {
                this.createAndRegisterElementInfo(galleryMgr, classLoader, template, APP_WIZARD_RULE, folder);
            }
            this.createAndRegisterElementInfo(galleryMgr, classLoader, template, APP_WIZARD_RULE, APPLICATIONS_GALLERY_PATH);
        }
    }

    private void registerProjectTemplates(GalleryManager galleryMgr, TemplateManager templateMgr, ClassLoader classLoader) {
        String icon = PROJECT_WIZARD_ICON;
        for (ProjectTemplate template : templateMgr.getProjectTemplates()) {
            if (!template.isValid()) {
                Assert.println((String)(template.getName() + " is not valid a valid template"));
                continue;
            }
            if (template.isExcludeFromGallery() || '#' == template.getTemplateId().charAt(0)) continue;
            template.setIconFile(PROJECT_WIZARD_ICON);
            for (String folder : this.folders(template)) {
                this.createAndRegisterElementInfo(galleryMgr, classLoader, template, PROJECT_WIZARD_RULE, folder);
            }
            this.createAndRegisterElementInfo(galleryMgr, classLoader, template, PROJECT_WIZARD_RULE, PROJECTS_GALLERY_PATH);
        }
    }

    private Set<String> folders(AbstractTemplate template) {
        HashSet<String> set = new HashSet<String>();
        if (this._templateDefined.booleanValue()) {
            if (template.isDefaultTemplate()) {
                set.add("General");
                if (template.getGalleryFolder() != null) {
                    set.add(template.getGalleryFolder());
                }
            } else if (template.getGalleryFolder() != null && !"General".equals(template.getGalleryFolder())) {
                set.add(template.getGalleryFolder());
            }
        } else if (template.getGalleryFolder() != null) {
            set.add(template.getGalleryFolder());
        }
        return set;
    }

    private boolean checkIsDefaultTemplateDefined(List<ApplicationTemplate> appTemplates) {
        if (this._templateDefined == null) {
            this._templateDefined = Boolean.FALSE;
            TemplateCustomizationHook hook = TemplateCustomizationHook.get();
            if (hook.isDefaultTemplateDefined()) {
                String id = hook.getDefaultTemplateId();
                for (ApplicationTemplate t : appTemplates) {
                    if (!t.getTemplateId().equals(id)) continue;
                    this._templateDefined = Boolean.TRUE;
                    break;
                }
            }
        }
        return this._templateDefined;
    }

    private void createAndRegisterElementInfo(GalleryManager galleryMgr, ClassLoader classLoader, AbstractTemplate template, String ruleId, String ... galleryPath) {
        ElementInfo info = new ElementInfo();
        info.setPath(galleryPath);
        info.setInvokableClass(WIZARD_CLASS_KEY);
        info.setRule(ruleId);
        info.setInvokableClassLoader(classLoader);
        info.setId(template.getTemplateId());
        info.setName(template.getName());
        info.setDescription(template.getDescription());
        info.setIconFile(template.getIconFile());
        info.setTechnologyKeys(TEMPLATES_TECH_SCOPE_KEY);
        info.setUnsorted(template.isDefaultTemplate() || template.isUnsorted());
        info.setCanAddToMruMenu(false);
        this._galleryItems.add(info);
        galleryMgr.registerGalleryElement(info);
    }
}

