/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JToolBar;
import oracle.help.common.Topic;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;

public class NavigatorToolBar
extends JToolBar
implements NavigatorListener {
    private ArrayList _selectionEnabledItems = new ArrayList();
    private boolean _currentlyEnabled = false;

    public void addItem(Component item, Component beforeItem) {
        this.addItem(item, beforeItem, false);
    }

    public void addItem(Component item, Component beforeItem, boolean enableBasedOnSelection) {
        if (item != null) {
            int beforeIndex;
            if (enableBasedOnSelection) {
                this._selectionEnabledItems.add(item);
                if (this._currentlyEnabled) {
                    item.setEnabled(true);
                } else {
                    item.setEnabled(false);
                }
            }
            int atIndex = this.getComponentCount();
            if (beforeItem != null && (beforeIndex = this.getComponentIndex(beforeItem)) != -1) {
                atIndex = beforeIndex;
            }
            this.add(item, atIndex);
        }
    }

    public void enableItemBasedOnSelection(boolean enableOnSelection, Component item) {
        if (item != null) {
            if (enableOnSelection) {
                if (!this._selectionEnabledItems.contains(item)) {
                    this._selectionEnabledItems.add(item);
                    if (this._currentlyEnabled) {
                        item.setEnabled(true);
                    } else {
                        item.setEnabled(false);
                    }
                }
            } else if (this._selectionEnabledItems.contains(item)) {
                this._selectionEnabledItems.remove(item);
            }
        }
    }

    public void removeItem(Component item) {
        if (item != null) {
            if (this._selectionEnabledItems.contains(item)) {
                this._selectionEnabledItems.remove(item);
            }
            this.remove(item);
        }
    }

    @Override
    public void topicSelected(NavigatorEvent e) {
        if (e != null && e.getID() == 2000) {
            Topic aTopic = e.getTopic();
            boolean enable = false;
            if (aTopic != null && aTopic.hasTarget()) {
                enable = true;
            }
            if (this._currentlyEnabled != enable) {
                int iter = 0;
                for (iter = 0; iter < this._selectionEnabledItems.size(); ++iter) {
                    Component anItem = (Component)this._selectionEnabledItems.get(iter);
                    anItem.setEnabled(enable);
                }
            }
            this._currentlyEnabled = enable;
        }
    }

    @Override
    public void topicActivated(NavigatorEvent e) {
    }
}

