/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class ProgressDialog
extends JDialog {
    private boolean isCancelled = false;
    private JButton jButton1 = new JButton();
    private JProgressBar jProgressBar1 = new JProgressBar();
    private JLabel jLabel1 = new JLabel();

    public ProgressDialog(Frame parent) {
        super(parent, "", true);
        try {
            this.jbInit();
            this.jProgressBar1.setIndeterminate(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.setSize(new Dimension(389, 155));
        this.setResizable(false);
        this.setTitle(MessagesBundle.getMessage("Progress"));
        this.setModal(true);
        Frame frame = (Frame)this.getParent();
        if (frame != null) {
            int x = (int)frame.getLocationOnScreen().getX() + ((int)frame.getSize().getWidth() - (int)this.getSize().getWidth()) / 2;
            int y = (int)frame.getLocationOnScreen().getY() + ((int)frame.getSize().getHeight() - (int)this.getSize().getHeight()) / 2;
            Point p = new Point(x, y);
            this.setLocation(p);
        }
        this.jButton1.setText(MessagesBundle.getMessage("Cancel"));
        this.jButton1.setBounds(new Rectangle(135, 85, 105, 25));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.jButton1_actionPerformed(e);
            }
        });
        this.jProgressBar1.setBounds(new Rectangle(60, 45, 265, 25));
        this.jProgressBar1.setForeground(new Color(52, 113, 211));
        this.jLabel1.setText(MessagesBundle.getMessage("Task_message"));
        this.jLabel1.setBounds(new Rectangle(60, 20, 265, 20));
        this.getContentPane().add((Component)this.jLabel1, null);
        this.getContentPane().add((Component)this.jProgressBar1, null);
        this.getContentPane().add((Component)this.jButton1, null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressDialog.this.isCancelled = true;
            }
        });
    }

    public void setMinMaxValues(int min, int max) {
        this.jProgressBar1.setMinimum(min);
        this.jProgressBar1.setMaximum(max);
    }

    public void setIndeterminate(boolean value) {
        this.jProgressBar1.setIndeterminate(value);
    }

    private void jButton1_actionPerformed(ActionEvent e) {
        this.Cancel();
    }

    public void setTaskMessage(String message) {
        this.jLabel1.setText(message);
    }

    public void setProgressValue(int value) {
        this.jProgressBar1.setValue(value);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void Cancel() {
        this.isCancelled = true;
        this.setVisible(false);
    }

    public void enableCancelButton() {
        this.jButton1.setEnabled(true);
    }

    public void disableCancelButton() {
        this.jButton1.setEnabled(false);
    }
}

