/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui.actiongroup;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.cs.CSTransformer;
import oracle.maps.layer.ui.ManipulatorLayer;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.ui.CollapsiblePanel;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.SDEUIComponent;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.layer.TopologySetLayer;

public class ManipulatorPane
extends JPanel
implements SDEUIComponent,
ChangeListener,
PropertyChangeListener {
    private MainAppPanel mainApp = null;
    private boolean supressPC = false;
    private Format format = new DecimalFormat("0.000");
    private JLabel angleLabel = new JLabel(Icons.getIcon("rotatedocument90left_ena.png"));
    private JFormattedTextField angleField = new JFormattedTextField(this.format);
    private JLabel scaleXLabel = new JLabel(Icons.getIcon("scale_x.png"));
    private JFormattedTextField scaleXField = new JFormattedTextField(this.format);
    private JLabel scaleYLabel = new JLabel(Icons.getIcon("scale_y.png"));
    private JFormattedTextField scaleYField = new JFormattedTextField(this.format);
    private JLabel translateXLabel = new JLabel(Icons.getIcon("move_x.png"));
    private JFormattedTextField translateXField = new JFormattedTextField(this.format);
    private JLabel translateYLabel = new JLabel(Icons.getIcon("move_y.png"));
    private JFormattedTextField translateYField = new JFormattedTextField(this.format);
    private JPanel buttonPanel = new JPanel();
    private JButton applyTargetButton = new JButton(Icons.getIcon("target.png"));
    private JButton applyAllButton = new JButton(Icons.getIcon("resizegraph_ena.png"));
    private JButton discardButton = new JButton(Icons.getIcon("ora_trashempty.png"));
    private JFormattedTextField[] fields = new JFormattedTextField[]{this.angleField, this.scaleXField, this.scaleYField, this.translateXField, this.translateYField};
    private JButton[] buttons = new JButton[]{this.applyTargetButton, this.applyAllButton, this.discardButton};

    public ManipulatorPane(MainAppPanel mainApp) {
        this.mainApp = mainApp;
        this.mainApp.getEditSessionPanel().addChangeListener(this);
        this.setName(MessagesBundle.getMessage("Transformation"));
        this.reset();
        this.angleField.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_rotate"));
        this.angleLabel.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_rotate"));
        this.scaleXField.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_scale_x"));
        this.scaleXLabel.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_scale_x"));
        this.scaleYField.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_scale_y"));
        this.scaleYLabel.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_scale_y"));
        this.translateXField.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_translate_x"));
        this.translateXLabel.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_translate_x"));
        this.translateYField.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_translate_y"));
        this.translateYLabel.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_translate_y"));
        for (JFormattedTextField jFormattedTextField : this.fields) {
            jFormattedTextField.setHorizontalAlignment(4);
            jFormattedTextField.setColumns(6);
            jFormattedTextField.addPropertyChangeListener("value", this);
        }
        this.applyTargetButton.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_save_target"));
        this.applyTargetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ManipulatorPane.this.getManipulator() == null) {
                    return;
                }
                ManipulatorPane.this.supressPC = true;
                for (JFormattedTextField field : ManipulatorPane.this.fields) {
                    try {
                        field.commitEdit();
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                }
                ManipulatorPane.this.supressPC = false;
                ManipulatorPane.this.getManipulator().commitChanges(false, false);
            }
        });
        this.applyAllButton.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_save_all"));
        this.applyAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ManipulatorPane.this.getManipulator() == null) {
                    return;
                }
                ManipulatorPane.this.supressPC = true;
                for (JFormattedTextField field : ManipulatorPane.this.fields) {
                    try {
                        field.commitEdit();
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                }
                ManipulatorPane.this.supressPC = false;
                ManipulatorPane.this.getManipulator().commitChanges();
            }
        });
        this.discardButton.setToolTipText(MessagesBundle.getMessage("Tooltip_manipulator_discard"));
        this.discardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ManipulatorPane.this.getManipulator() == null) {
                    return;
                }
                ManipulatorPane.this.getManipulator().setToTransform(1.0, 1.0, 0.0, 0.0, 0.0);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout());
        for (JComponent jComponent : this.buttons) {
            this.buttonPanel.add(jComponent);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.angleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.angleField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scaleXLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.scaleXField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scaleYLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.scaleYField, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.translateXLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.translateXField, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.translateYLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.translateYField, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setEnabled(false);
    }

    public void reset() {
        this.supressPC = true;
        this.angleField.setValue(new Double(0.0));
        this.scaleXField.setValue(new Double(1.0));
        this.scaleYField.setValue(new Double(1.0));
        this.translateXField.setValue(new Double(0.0));
        this.translateYField.setValue(new Double(0.0));
        this.supressPC = false;
        this.applyTargetButton.setEnabled(false);
        this.applyAllButton.setEnabled(false);
        this.discardButton.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            for (JComponent jComponent : this.buttons) {
                ((AbstractButton)jComponent).setEnabled(enabled);
            }
        }
        for (JComponent jComponent : this.fields) {
            jComponent.setEnabled(enabled);
        }
        CollapsiblePanel cp = CollapsiblePanel.getCollapsiblePanelParent(this);
        if (cp != null) {
            cp.setExpanded(enabled);
        }
    }

    public boolean hasEnabledButtons() {
        for (JButton btn : this.buttons) {
            if (!btn.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.supressPC || !this.getManipulator().isVisible()) {
            return;
        }
        double angle = ((Number)this.angleField.getValue()).doubleValue();
        double scaleX = ((Number)this.scaleXField.getValue()).doubleValue();
        double scaleY = ((Number)this.scaleYField.getValue()).doubleValue();
        double transX = ((Number)this.translateXField.getValue()).doubleValue();
        double transY = ((Number)this.translateYField.getValue()).doubleValue();
        double rads = angle;
        rads = rads < 180.0 ? (rads *= -1.0) : 360.0 - rads;
        rads = rads * Math.PI / 180.0;
        double[] pt = new double[]{transX, transY};
        int mapSrid = this.getMapCanvas().getMapRegion().getMapSrid();
        int userSrid = this.getMapCanvas().getMapRegion().getUserSrid();
        CSTransformer.transform(pt, 2, new int[]{userSrid, mapSrid}, pt);
        this.getManipulator().setToTransform(scaleX, scaleY, pt[0], pt[1], rads);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src instanceof EditSessionPanel) {
            ManipulatorLayer newManip;
            EditSession newSession;
            ManipulatorLayer oldManip;
            EditSessionPanel panel = (EditSessionPanel)src;
            EditSessionPanel.SessionChangeEvent evt = (EditSessionPanel.SessionChangeEvent)e;
            EditSession oldSession = evt.getOldSession();
            if (oldSession != null && oldSession.getLayers() != null && (oldManip = (ManipulatorLayer)oldSession.getLayers().getLayerByTag("manipulatorLayer")) != null) {
                oldManip.removeChangeListener(this);
            }
            if ((newSession = evt.getNewSession()) != null && newSession.getLayers() != null && (newManip = (ManipulatorLayer)newSession.getLayers().getLayerByTag("manipulatorLayer")) != null) {
                newManip.addChangeListener(this);
            }
        } else if (src instanceof ManipulatorLayer) {
            boolean enabled = this.getManipulator().isEnabled();
            if (enabled) {
                List<GeoObject> feats = this.getManipulator().getSelectedFeatures();
                if (feats.size() == 0) {
                    this.setEnabled(false);
                    return;
                }
                Layer manipLayer = feats.get(0).getLayer();
                if (manipLayer == null || manipLayer instanceof TopologySetLayer || manipLayer instanceof TopologyPrimitiveLayer) {
                    this.setEnabled(false);
                    this.getManipulator().disableAllHandles();
                    return;
                }
            }
            this.setEnabled(enabled);
            if (!enabled) {
                return;
            }
            double[] params = this.getManipulator().getTranformationParameters();
            if (params[0] == 1.0 && params[1] == 1.0 && params[2] == 0.0 && params[3] == 0.0 && params[4] == 0.0) {
                this.reset();
                return;
            }
            this.applyTargetButton.setEnabled(true);
            this.applyAllButton.setEnabled(true);
            this.discardButton.setEnabled(true);
            double angle = params[4] * 180.0 / Math.PI;
            if (angle < 0.0) {
                angle *= -1.0;
            } else if (angle > 0.0) {
                angle = 360.0 - angle;
            }
            double[] pt = new double[]{params[2], params[3]};
            int mapSrid = this.getMapCanvas().getMapRegion().getMapSrid();
            int userSrid = this.getMapCanvas().getMapRegion().getUserSrid();
            CSTransformer.transform(pt, 2, new int[]{mapSrid, userSrid}, pt);
            this.supressPC = true;
            this.angleField.setValue(angle);
            this.scaleXField.setValue(params[0]);
            this.scaleYField.setValue(params[1]);
            this.translateXField.setValue(pt[0]);
            this.translateYField.setValue(pt[1]);
            this.supressPC = false;
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void updateUIStatus() {
    }

    private ManipulatorLayer getManipulator() {
        return (ManipulatorLayer)this.mainApp.getMapCanvas().getLayerManager().getLayerByTag("manipulatorLayer");
    }

    private MapCanvas getMapCanvas() {
        return this.mainApp.getMapCanvas();
    }
}

