/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import oracle.mapviewer.share.MVThemeMetadata;
import oracle.mapviewer.share.MVTileLayerMetadata;
import oracle.mapviewer.share.Sequence;
import oracle.mapviewer.share.SpatialTableMetadata;

public class DataSourceMetadata {
    private Vector<String> editSessionNames = new Vector();
    private Vector<SpatialTableMetadata> spatialMetadata = new Vector();
    private Vector<MVThemeMetadata> mvPredefinedThemes = new Vector();
    private Vector<MVTileLayerMetadata> mvTileLayers = new Vector();
    private Vector<String> mvBaseMaps = new Vector();
    private Vector<Sequence> dbSequences = new Vector();

    public void clear() {
        this.editSessionNames.clear();
        this.spatialMetadata.clear();
        this.mvPredefinedThemes.clear();
        this.mvTileLayers.clear();
        this.mvBaseMaps.clear();
        this.dbSequences.clear();
    }

    public Vector<String> getEditSessionNames() {
        return this.editSessionNames;
    }

    public void setEditSessionNames(Vector<String> ednames) {
        if (ednames == null) {
            this.editSessionNames.clear();
        } else {
            this.editSessionNames = ednames;
        }
    }

    public void addEditSession(String name) {
        if (name == null) {
            return;
        }
        if (this.editSessionNames == null) {
            this.editSessionNames = new Vector();
        }
        this.editSessionNames.add(name);
    }

    public void removeEditSession(String name) {
        if (name == null || this.editSessionNames == null) {
            return;
        }
        this.editSessionNames.remove(name);
    }

    public Vector<SpatialTableMetadata> getSpatialTableMetadata() {
        return this.spatialMetadata;
    }

    public void setSpatialTableMetadata(Vector<SpatialTableMetadata> metadata) {
        if (metadata == null) {
            this.spatialMetadata.clear();
        } else {
            this.spatialMetadata = metadata;
        }
    }

    public Vector<MVThemeMetadata> getMVPredefinedThemeMetadata() {
        return this.mvPredefinedThemes;
    }

    public void setMVPredefinedThemeMetadata(Vector<MVThemeMetadata> metadata) {
        if (metadata == null) {
            this.mvPredefinedThemes.clear();
        } else {
            this.mvPredefinedThemes = metadata;
        }
    }

    public Vector<MVTileLayerMetadata> getMVTileLayerMetadata() {
        return this.mvTileLayers;
    }

    public void setMVTileLayerMetadata(Vector<MVTileLayerMetadata> metadata) {
        if (metadata == null) {
            this.mvTileLayers.clear();
        } else {
            this.mvTileLayers = metadata;
        }
    }

    public String[] getSpatialTables(String spatialType) {
        if (this.spatialMetadata == null || this.spatialMetadata.size() == 0 || spatialType == null) {
            return null;
        }
        ArrayList<String> tables = new ArrayList<String>();
        for (int i = 0; i < this.spatialMetadata.size(); ++i) {
            SpatialTableMetadata spmeta = this.spatialMetadata.get(i);
            if (!spmeta.getType().equalsIgnoreCase(spatialType) || tables.contains(spmeta.getName())) continue;
            tables.add(spmeta.getName());
        }
        if (tables == null) {
            return null;
        }
        Collections.sort(tables);
        return tables.toArray(new String[tables.size()]);
    }

    public String[] getTableSpatialColumns(String geomTable, String spatialType) {
        if (geomTable == null || this.spatialMetadata == null || this.spatialMetadata.size() == 0) {
            return null;
        }
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < this.spatialMetadata.size(); ++i) {
            SpatialTableMetadata spmeta = this.spatialMetadata.get(i);
            if (!spmeta.getName().equalsIgnoreCase(geomTable) || !spmeta.getType().equalsIgnoreCase(spatialType)) continue;
            columns.add(spmeta.getSpatialColumn());
        }
        if (columns == null) {
            return null;
        }
        Collections.sort(columns);
        return columns.toArray(new String[columns.size()]);
    }

    public int getSpatialColumnSRID(String spatialTable, String spatialColumn) {
        if (spatialTable == null || spatialColumn == null || this.spatialMetadata == null || this.spatialMetadata.size() == 0) {
            return 0;
        }
        for (int i = 0; i < this.spatialMetadata.size(); ++i) {
            SpatialTableMetadata spmeta = this.spatialMetadata.get(i);
            if (!spatialTable.equalsIgnoreCase(spmeta.getName()) || !spatialColumn.equalsIgnoreCase(spmeta.getSpatialColumn())) continue;
            return spmeta.getSRID();
        }
        return 0;
    }

    public SpatialTableMetadata getSpatialTableMetadata(String spatialTable, String spatialColumn) {
        if (spatialTable == null || spatialColumn == null || this.spatialMetadata == null || this.spatialMetadata.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.spatialMetadata.size(); ++i) {
            SpatialTableMetadata spmeta = this.spatialMetadata.get(i);
            if (!spatialTable.equalsIgnoreCase(spmeta.getName()) || !spatialColumn.equalsIgnoreCase(spmeta.getSpatialColumn())) continue;
            return spmeta;
        }
        return null;
    }

    public boolean containsEditSession(String name) {
        if (name == null) {
            return false;
        }
        return this.editSessionNames.contains(name);
    }

    public MVThemeMetadata getPredefinedThemeMetadata(String theme) {
        if (theme == null || this.mvPredefinedThemes == null || this.mvPredefinedThemes.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.mvPredefinedThemes.size(); ++i) {
            MVThemeMetadata meta = this.mvPredefinedThemes.get(i);
            if (!meta.getName().equalsIgnoreCase(theme)) continue;
            return meta;
        }
        return null;
    }

    public int getPredefinedThemeSRID(String theme) {
        MVThemeMetadata meta = this.getPredefinedThemeMetadata(theme);
        if (meta == null) {
            return 0;
        }
        return meta.getSRID();
    }

    public MVTileLayerMetadata getTileLayerMetadata(String tile) {
        if (tile == null || this.mvTileLayers == null || this.mvTileLayers.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.mvTileLayers.size(); ++i) {
            MVTileLayerMetadata meta = this.mvTileLayers.get(i);
            if (!meta.getName().equalsIgnoreCase(tile)) continue;
            return meta;
        }
        return null;
    }

    public void addSpatialTableMetadata(SpatialTableMetadata meta) {
        if (meta == null) {
            return;
        }
        this.spatialMetadata.add(meta);
    }

    public Vector<String> getMapViewerBaseMaps() {
        return this.mvBaseMaps;
    }

    public void setMVBaseMaps(Vector<String> basemaps) {
        if (basemaps == null) {
            this.mvBaseMaps.clear();
        } else {
            this.mvBaseMaps = basemaps;
        }
    }

    public void addSequence(Sequence seq) {
        if (seq == null) {
            return;
        }
        this.dbSequences.add(seq);
    }

    public Sequence getSequence(String sequence) {
        if (sequence == null || this.dbSequences.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.dbSequences.size(); ++i) {
            Sequence seq = this.dbSequences.get(i);
            if (!sequence.equalsIgnoreCase(seq.getName())) continue;
            return seq;
        }
        return null;
    }

    public void setSequences(Vector<Sequence> sequences) {
        if (sequences == null) {
            this.dbSequences.clear();
        } else {
            this.dbSequences = sequences;
        }
    }

    public String[] getSequences() {
        if (this.dbSequences == null || this.dbSequences.size() == 0) {
            return null;
        }
        ArrayList<String> seqs = new ArrayList<String>();
        for (int i = 0; i < this.dbSequences.size(); ++i) {
            seqs.add(this.dbSequences.get(i).getName());
        }
        Collections.sort(seqs);
        return seqs.toArray(new String[seqs.size()]);
    }
}

