/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.util.List;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

class QSortAlgorithm {
    QSortAlgorithm() {
    }

    void quickSort(List obList, int lb, int ub) {
        if (lb < ub) {
            int pivot = this.rearrange(obList, lb, ub);
            this.quickSort(obList, lb, pivot - 1);
            this.quickSort(obList, pivot + 1, ub);
        }
    }

    int rearrange(List obList, int lb, int ub) {
        int lo = lb;
        int hi = ub;
        int pivot = lb;
        double pivotVal = ((Model3DFlatFace)obList.get(pivot)).getDistance();
        while (lo < hi) {
            while (hi > lo && ((Model3DFlatFace)obList.get(hi)).getDistance() <= pivotVal) {
                --hi;
            }
            pivot = hi;
            if (hi == lo) continue;
            this.swapElements(obList, hi, lo);
            while (lo < hi && ((Model3DFlatFace)obList.get(lo)).getDistance() >= pivotVal) {
                ++lo;
            }
            pivot = lo;
            if (hi == lo) continue;
            this.swapElements(obList, hi, lo);
        }
        return pivot;
    }

    void sortDistance(List obList, Point3d viewer) {
        this.quickSort(obList, 0, obList.size() - 1);
    }

    void swapElements(List obList, int hi, int lo) {
        if (lo == hi) {
            return;
        }
        Model3DFlatFace T = (Model3DFlatFace)obList.get(lo);
        obList.set(lo, obList.get(hi));
        obList.set(hi, T);
    }
}

