/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.utilities;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class TDGTimer
implements Runnable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean repeat;
    protected boolean execute;
    protected int delay;
    protected String actionCommand;
    protected ActionListener actionListener = null;
    protected transient Thread thread;

    public TDGTimer() {
        this(1000, false);
    }

    public TDGTimer(int d) {
        this(d, false);
    }

    public TDGTimer(boolean r) {
        this(1000, r);
    }

    public TDGTimer(int d, boolean r) {
        this.delay = d;
        this.repeat = r;
        this.execute = false;
        this.thread = null;
    }

    public void setDelay(int d) {
        Integer newValue = new Integer(d);
        Integer oldValue = new Integer(this.delay);
        this.delay = d;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setRepeat(boolean f) {
        Boolean newValue = new Boolean(f);
        Boolean oldValue = new Boolean(this.repeat);
        this.repeat = f;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public boolean getRepeat() {
        return this.isRepeat();
    }

    public synchronized void start() {
        this.execute = true;
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.resume();
        } else {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public synchronized void start(int d) {
        this.setDelay(d);
        this.start();
    }

    public synchronized void start(boolean r) {
        this.setRepeat(r);
        this.start();
    }

    public synchronized void start(int d, boolean r) {
        this.setDelay(d);
        this.setRepeat(r);
        this.start();
    }

    public synchronized void stop() {
        this.execute = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @Override
    public void run() {
        do {
            try {
                Thread.sleep(this.delay);
                if (!this.execute) continue;
                this.sourceActionEvent();
            }
            catch (InterruptedException e) {
                return;
            }
        } while (this.repeat);
    }

    public void finalize() {
        try {
            if (this.thread != null) {
                this.thread.destroy();
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.thread = null;
        this.actionListener = null;
    }

    public void setActionCommand(String command) {
        String oldValue = this.actionCommand;
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.execute = false;
        this.thread = new Thread(this);
    }
}

