/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg.batik;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import oracle.dss.presutil.PresUtils;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class LinearGradientExtension
extends DefaultExtensionHandler {
    LinearGradientExtension() {
    }

    public SVGPaintDescriptor handlePaint(Paint paint, SVGGeneratorContext generatorCtx) {
        if (paint instanceof LinearGradientPaint) {
            Color[] stops;
            LinearGradientPaint gradient = (LinearGradientPaint)paint;
            String id = generatorCtx.getIDGenerator().generateID("gradient");
            Document doc = generatorCtx.getDOMFactory();
            Element grad = doc.createElementNS("http://www.w3.org/2000/svg", "linearGradient");
            grad.setAttributeNS(null, "id", id);
            grad.setAttributeNS(null, "gradientUnits", "userSpaceOnUse");
            Point2D pt = gradient.getStartPoint();
            grad.setAttributeNS(null, "x1", String.valueOf(pt.getX()));
            grad.setAttributeNS(null, "y1", String.valueOf(pt.getY()));
            pt = gradient.getEndPoint();
            grad.setAttributeNS(null, "x2", String.valueOf(pt.getX()));
            grad.setAttributeNS(null, "y2", String.valueOf(pt.getY()));
            if (gradient.getCycleMethod() == MultipleGradientPaint.CycleMethod.REFLECT) {
                grad.setAttributeNS(null, "spreadMethod", "reflect");
            }
            if (gradient.getCycleMethod() == MultipleGradientPaint.CycleMethod.REPEAT) {
                grad.setAttributeNS(null, "spreadMethod", "repeat");
            }
            if ((stops = gradient.getColors()) != null) {
                for (int i = 0; i < stops.length; ++i) {
                    Element stop = doc.createElementNS("http://www.w3.org/2000/svg", "stop");
                    stop.setAttribute("stop-color", PresUtils.getColorValue(stops[i]));
                    stop.setAttribute("offset", String.valueOf(gradient.getFractions()[i]));
                    grad.appendChild(stop);
                }
            }
            return new SVGPaintDescriptor("url(#" + id + ")", "1", grad);
        }
        return null;
    }
}

