/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.hive.HiveTableBuilder;
import oracle.javatools.util.ModelUtil;

public class HivePartitionBuilder
extends AbstractDBObjectBuilder<HivePartition> {
    public HivePartitionBuilder(HiveDatabaseImpl hiveDatabaseImpl) {
        super((AbstractDBObjectProvider)hiveDatabaseImpl, "HivePartition");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"HiveStorageProperties", "HiveSkewProperties"})
    public void buildUsingDescribe(HivePartition hivePartition) throws DBException {
        String string = hivePartition.getName();
        Table table = (Table)DBUtil.findParentOfType((DBObject)hivePartition, Table.class);
        if (table != null && ModelUtil.hasLength((String)string)) {
            HiveDatabaseImpl hiveDatabaseImpl = (HiveDatabaseImpl)this.getProvider();
            HiveTableBuilder.DescribeBuilder describeBuilder = new HiveTableBuilder.DescribeBuilder(hiveDatabaseImpl);
            describeBuilder.describe("describe formatted " + DBUtil.getFullyQualifiedName((DBObject)table, (boolean)true) + " partition(" + string + ")", table);
            HiveStorageProperties hiveStorageProperties = new HiveStorageProperties();
            hivePartition.setProperty("HiveStorageProperties", (Object)hiveStorageProperties);
            describeBuilder.extractProperties(HiveTableBuilder.s_propertyMap, (DBObject)hiveStorageProperties);
            describeBuilder.extractSkew((DBObject)hivePartition);
        }
    }
}

