/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.hive.HiveBucketProperties;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HivePartitionProperties;
import oracle.javatools.db.hive.HivePartitionsBuilder;
import oracle.javatools.db.hive.HiveSkewProperties;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.hive.TblProperty;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class HiveTableBuilder
extends AbstractDBObjectBuilder<Table> {
    private static final String DEFAULT_COMMENT = "None";
    private static final String TABLE_TYPE_PROP = "Table Type:";
    private static final String TABLE_TYPE_EXTERNAL = "EXTERNAL_TABLE";
    private static final String INPUTFORMAT_PROP = "InputFormat:";
    private static final String OUTPUTFORMAT_PROP = "OutputFormat:";
    private static final String SERDE_PROP = "SerDe Library:";
    private static final String LOCATION_PROP = "Location:";
    private static final String NUM_BUCKETS_PROP = "Num Buckets:";
    private static final String BUCKET_COLS_PROP = "Bucket Columns:";
    private static final String BUCKET_SORT_COLS_PROP = "Sort Columns:";
    private static final String SKEW_COLS_PROP = "Skewed Columns:";
    private static final String SKEW_VALS_PROP = "Skewed Values:";
    private static final String SKEW_STORED_AS_DIRS = "Stored As SubDirectories:";
    private static final String YES = "Yes";
    private static final String TBLPROPERTIES_PROP = "Table Parameters:";
    private static final String PARTPROPS_PROP = "Partition Parameters:";
    private static final String TBLPROP_COMMENT = "comment";
    private static final String TBLPROP_STORAGE_HANDLER = "storage_handler";
    private static final String SERDEPROPERTIES_PROP = "Storage Desc Params:";
    static final Map<String, String> s_propertyMap;
    private static final Collection<String> s_mapHeaders;
    private static Pattern s_orderPattern;

    public HiveTableBuilder(HiveDatabaseImpl hiveDatabaseImpl) {
        super((AbstractDBObjectProvider)hiveDatabaseImpl, "TABLE");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columns", "TableType", "Comment", "HivePartitionProperties", "HiveBucketProperties", "HiveStorageProperties", "HiveSkewProperties", "TBLPROPERTIES"})
    public void buildUsingDescribe(Table table) throws DBException {
        Object object;
        Object object2;
        HiveDatabaseImpl hiveDatabaseImpl = (HiveDatabaseImpl)this.getProvider();
        DescribeBuilder describeBuilder = new DescribeBuilder(hiveDatabaseImpl);
        describeBuilder.describe("describe formatted " + DBUtil.getFullyQualifiedName((DBObject)table, (boolean)true), table);
        Map<String, Column> map = describeBuilder.getColumnMap();
        Map<String, String> map2 = describeBuilder.getMetadata();
        table.setColumns(map.values().toArray(new Column[map.size()]));
        Table.TableType tableType = TABLE_TYPE_EXTERNAL.equals(map2.get(TABLE_TYPE_PROP)) ? Table.TableType.EXTERNAL : Table.TableType.NORMAL;
        table.setProperty("TableType", (Object)tableType);
        HiveStorageProperties hiveStorageProperties = new HiveStorageProperties();
        table.setProperty("HiveStorageProperties", (Object)hiveStorageProperties);
        describeBuilder.extractProperties(s_propertyMap, (DBObject)hiveStorageProperties);
        HiveBucketProperties hiveBucketProperties = new HiveBucketProperties();
        if (describeBuilder.extractColumnList(BUCKET_COLS_PROP, (DBObject)hiveBucketProperties, "bucketColumns")) {
            describeBuilder.extractInteger(NUM_BUCKETS_PROP, (DBObject)hiveBucketProperties, "numberOfBuckets", false);
            describeBuilder.extractSortColList(BUCKET_SORT_COLS_PROP, (DBObject)hiveBucketProperties, "bucketSortColumns");
            table.setProperty("HiveBucketProperties", (Object)hiveBucketProperties);
        }
        describeBuilder.extractSkew((DBObject)table);
        List<DBObjectID> list = describeBuilder.getPartitionColumns();
        if (!list.isEmpty()) {
            object2 = new HivePartitionProperties();
            object2.setPartitionColumns(list.toArray(new DBObjectID[list.size()]));
            hiveDatabaseImpl.setHiveBuilder(object2, new HivePartitionsBuilder(hiveDatabaseImpl));
            table.setProperty("HivePartitionProperties", object2);
        }
        if ((object2 = describeBuilder.getPropertyMap(TBLPROPERTIES_PROP)) != null) {
            String string;
            object = (String)object2.remove(TBLPROP_COMMENT);
            if (ModelUtil.hasLength((String)object)) {
                table.setProperty("Comment", object);
                HiveTableBuilder.fixComment((DBObject)table);
            }
            if (ModelUtil.hasLength((String)(string = (String)object2.get(TBLPROP_STORAGE_HANDLER)))) {
                hiveStorageProperties.setStorageHandlerClass(string);
            }
            table.setProperty("TBLPROPERTIES", (Object)describeBuilder.createPropertiesModel((Map<String, String>)object2));
        }
        if ((object = describeBuilder.getPropertyMap(SERDEPROPERTIES_PROP)) != null) {
            hiveStorageProperties.setSerDeProperties(describeBuilder.createPropertiesModel((Map<String, String>)object));
        }
    }

    private boolean hasProperty(DBObject dBObject, String ... stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (dBObject.getProperty(string) == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static void fixComment(DBObject dBObject) {
        String string = (String)dBObject.getProperty("Comment");
        if (string != null && string.contains("\\n")) {
            string = string.replace("\\n", "\n");
            dBObject.setProperty("Comment", (Object)string);
        }
    }

    static {
        s_mapHeaders = Arrays.asList(TBLPROPERTIES_PROP, SERDEPROPERTIES_PROP, PARTPROPS_PROP);
        s_propertyMap = new HashMap<String, String>();
        s_propertyMap.put(LOCATION_PROP, "hdfsLocation");
        s_propertyMap.put(INPUTFORMAT_PROP, "inputFormatClass");
        s_propertyMap.put(OUTPUTFORMAT_PROP, "outputFormatClass");
        s_propertyMap.put(SERDE_PROP, "serDeClass");
    }

    static class DescribeBuilder {
        private final HiveDatabaseImpl m_db;
        private final Map<String, Column> m_colMap = new LinkedHashMap<String, Column>();
        private final List<DBObjectID> m_partedCols = new ArrayList<DBObjectID>();
        private final Map<String, String> m_metadata = new HashMap<String, String>();
        private final Map<String, Map<String, String>> m_propertyMaps = new HashMap<String, Map<String, String>>();

        DescribeBuilder(HiveDatabaseImpl hiveDatabaseImpl) {
            this.m_db = hiveDatabaseImpl;
        }

        private Logger getLogger() {
            return DBLog.getLogger((Object)this);
        }

        Map<String, Column> getColumnMap() {
            return this.m_colMap;
        }

        List<DBObjectID> getPartitionColumns() {
            return this.m_partedCols;
        }

        Map<String, String> getPropertyMap(String string) {
            return this.m_propertyMaps.get(string);
        }

        Map<String, String> getMetadata() {
            return this.m_metadata;
        }

        public void describe(String string, final Table table) throws DBException {
            final ArrayList arrayList = new ArrayList();
            QueryWrapper queryWrapper = new QueryWrapper((Database)this.m_db, string);
            queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException, SQLException {
                    Boolean bl = null;
                    boolean bl2 = false;
                    String string = null;
                    while (resultSet.next()) {
                        Object object;
                        Object object2;
                        String string2;
                        String string3 = this.getTrimmedString(resultSet, 1);
                        if (string3 != null && string3.equals("# col_name")) {
                            if (Boolean.TRUE.equals(bl)) {
                                bl2 = true;
                            }
                            bl = false;
                            continue;
                        }
                        if (bl == null) continue;
                        if (ModelUtil.hasLength((String)string3)) {
                            if (string3.startsWith("# ")) {
                                bl = true;
                                string = null;
                                continue;
                            }
                            if (bl.booleanValue()) {
                                if (s_mapHeaders.contains(string3)) {
                                    string = string3;
                                    continue;
                                }
                                m_metadata.put(string3, this.getTrimmedString(resultSet, 2));
                                continue;
                            }
                            string2 = new Column(string3);
                            string2.setID((DBObjectID)new NameBasedID("COLUMN", string3, table.getID()));
                            object2 = this.getTrimmedString(resultSet, 2);
                            arrayList.add(new Tuple((Object)string2, object2));
                            object = resultSet.getString(3);
                            if (!resultSet.wasNull() && ModelUtil.hasLength((String)object) && !HiveTableBuilder.DEFAULT_COMMENT.equals(object)) {
                                string2.setProperty("Comment", object);
                            }
                            if (!bl2) continue;
                            m_partedCols.add(string2.getID());
                            continue;
                        }
                        if (string != null) {
                            string2 = this.getTrimmedString(resultSet, 2);
                            if (!ModelUtil.hasLength((String)string2)) continue;
                            object2 = m_propertyMaps.get(string);
                            if (object2 == null) {
                                object2 = new LinkedHashMap<String, String>();
                                m_propertyMaps.put(string, (Map<String, String>)object2);
                            }
                            object2.put(string2, this.getTrimmedString(resultSet, 3));
                            continue;
                        }
                        if (!Boolean.FALSE.equals(bl) || arrayList.isEmpty() || !ModelUtil.hasLength((String)(string2 = resultSet.getString(3)))) continue;
                        object2 = (Tuple)arrayList.get(arrayList.size() - 1);
                        object = (Column)object2.object1();
                        Object object3 = (String)object.getProperty("Comment");
                        object3 = (String)object3 + "\n" + string2;
                        object.setProperty("Comment", object3);
                    }
                }
            });
            for (Tuple tuple : arrayList) {
                Column column = (Column)tuple.object1();
                DataTypeUsage dataTypeUsage = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)this.m_db, (Schema)table.getSchema(), (String)((String)tuple.object2()));
                column.setDataTypeUsage(dataTypeUsage);
                HiveTableBuilder.fixComment((DBObject)column);
                this.m_colMap.put(column.getName(), column);
            }
        }

        private String getTrimmedString(ResultSet resultSet, int n) throws SQLException {
            String string = resultSet.getString(n);
            return string == null ? null : string.trim();
        }

        void extractProperties(Map<String, String> map, DBObject dBObject) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = this.m_metadata.get(entry.getKey());
                if (string == null) continue;
                dBObject.setProperty(entry.getValue(), (Object)string);
            }
        }

        void extractInteger(String string, DBObject dBObject, String string2, boolean bl) {
            Integer n = null;
            String string3 = this.m_metadata.get(string);
            if (string3 != null && ModelUtil.hasLength((String)(string3 = string3.trim()))) {
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.getLogger().warning("Invalid number " + string3 + " for " + string2);
                }
            }
            if (n != null && (bl || n >= 0)) {
                dBObject.setProperty(string2, (Object)n);
            }
        }

        boolean extractColumnList(String string, DBObject dBObject, String string2) {
            boolean bl = false;
            String string3 = this.m_metadata.get(string);
            if (ModelUtil.hasLength((String)string3)) {
                string3 = this.stripSquareBrackets(string3);
                String[] stringArray = string3.split(",");
                ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
                for (String string4 : stringArray) {
                    DBObjectID dBObjectID = this.getColumnID(string4.trim());
                    if (dBObjectID == null) continue;
                    arrayList.add(dBObjectID);
                }
                if (!arrayList.isEmpty()) {
                    dBObject.setProperty(string2, (Object)arrayList.toArray(new DBObjectID[arrayList.size()]));
                    bl = true;
                }
            }
            return bl;
        }

        private String stripSquareBrackets(String string) {
            String string2 = string;
            int n = string2.length();
            if (string2.charAt(0) == '[' && string2.charAt(n - 1) == ']') {
                string2 = string2.substring(1, n - 1);
            }
            return string2;
        }

        private DBObjectID getColumnID(String string) {
            DBObjectID dBObjectID = null;
            if (ModelUtil.hasLength((String)string)) {
                Column column = this.m_colMap.get(string);
                if (column == null) {
                    this.getLogger().warning("Column " + string + " not found");
                } else {
                    dBObjectID = column.getID();
                }
            }
            return dBObjectID;
        }

        void extractSortColList(String string, DBObject dBObject, String string2) {
            ArrayList<IndexObject> arrayList = new ArrayList<IndexObject>();
            String string3 = this.m_metadata.get(string);
            if (ModelUtil.hasLength((String)string3)) {
                try {
                    if (s_orderPattern == null) {
                        s_orderPattern = Pattern.compile("Order\\(col:(?<col>[^\\\\s,]+), order:(?<ord>[0|1])\\)");
                    }
                    Matcher matcher = s_orderPattern.matcher(string3);
                    while (matcher.find()) {
                        String string4 = matcher.group("col");
                        String string5 = matcher.group("ord");
                        IndexObject indexObject = (IndexObject)this.m_db.getObjectFactory().newObject(IndexObject.class);
                        indexObject.setExpressionSource(string4);
                        DBObjectID dBObjectID = this.getColumnID(string4);
                        if (dBObjectID != null) {
                            ColumnUsage columnUsage = new ColumnUsage(dBObjectID);
                            indexObject.setExpression((SQLFragment)columnUsage);
                        }
                        indexObject.setOrderType("0".equals(string5) ? IndexObject.OrderType.DESC : IndexObject.OrderType.ASC);
                        arrayList.add(indexObject);
                    }
                }
                catch (Exception exception) {
                    this.getLogger().log(DBLog.getExceptionLogLevel(), "Parsing Order list failed", exception);
                }
            }
            if (!arrayList.isEmpty()) {
                dBObject.setProperty(string2, (Object)arrayList.toArray(new IndexObject[arrayList.size()]));
            }
        }

        void extractSkew(DBObject dBObject) {
            HiveSkewProperties hiveSkewProperties = new HiveSkewProperties();
            if (this.extractColumnList(HiveTableBuilder.SKEW_COLS_PROP, (DBObject)hiveSkewProperties, "skewedColumns")) {
                dBObject.setProperty("HiveSkewProperties", (Object)hiveSkewProperties);
                this.extractSkewValues(HiveTableBuilder.SKEW_VALS_PROP, (DBObject)hiveSkewProperties, "skewedValues");
                if (HiveTableBuilder.YES.equalsIgnoreCase(this.m_metadata.get(HiveTableBuilder.SKEW_STORED_AS_DIRS))) {
                    hiveSkewProperties.setStoredAsDirectories(Boolean.valueOf(true));
                }
            }
        }

        private void extractSkewValues(String string, DBObject dBObject, String string2) {
            String string3 = this.m_metadata.get(string);
            if (ModelUtil.hasLength((String)string3)) {
                String[] stringArray;
                ArrayList<HivePartition> arrayList = new ArrayList<HivePartition>();
                string3 = this.stripSquareBrackets(string3);
                string3 = this.stripSquareBrackets(string3);
                for (String string4 : stringArray = string3.split(Pattern.quote("], ["))) {
                    arrayList.add(new HivePartition(string4.split(", ")));
                }
                if (!arrayList.isEmpty()) {
                    dBObject.setProperty(string2, (Object)arrayList.toArray(new HivePartition[arrayList.size()]));
                }
            }
        }

        TblProperty[] createPropertiesModel(Map<String, String> map) throws DBException {
            TblProperty[] tblPropertyArray = new TblProperty[map.size()];
            int n = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                tblPropertyArray[n++] = new TblProperty(entry.getKey(), entry.getValue());
            }
            return tblPropertyArray;
        }
    }
}

