/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleTablespaceBuilder;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.db.ora.RecycledObjectBuilder;

public class Oracle10g
extends Oracle9iR2 {
    Oracle10g(String string, String string2, Connection connection, int n) {
        super(string, string2, connection, n);
    }

    @Override
    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("RECYCLEBIN", (DBObjectBuilder)new RecycledObjectBuilder(this));
        this.registerBuilder("TABLESPACE", (DBObjectBuilder)new OracleTablespaceBuilder(this));
    }

    protected void finishDelete(SystemObject[] systemObjectArray) {
        super.finishDelete(systemObjectArray);
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        for (SystemObject systemObject : systemObjectArray) {
            if (!(systemObject instanceof RecycledObject)) continue;
            try {
                SchemaObject schemaObject = this.getObject(((RecycledObject)systemObject).getOriginalType(), ((RecycledObject)systemObject).getSchema(), ((RecycledObject)systemObject).getOriginalName());
                if (schemaObject == null) continue;
                arrayList.add(schemaObject);
            }
            catch (DBException dBException) {
                this.getLogger().warning(dBException.getMessage());
            }
        }
        if (arrayList.size() > 0) {
            this.fireObjectsAdded(arrayList);
        }
    }
}

