/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.compilation.CompilationResults;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;
import oracle.javatools.db.plsql.PlSqlIdentifier;

public class OracleLite
extends BaseOracleDatabase
implements OracleDatabaseLite {
    public static final String[] OLITE_SCHEMA_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM"};
    public static final String[] OLITE_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM", "INDEX", "CONSTRAINT", "SCHEMA"};

    OracleLite(String string, String string2, Connection connection, int n) {
        super(string, string2, connection, "Oracle Lite", n);
    }

    public boolean supportsJava() {
        return false;
    }

    public boolean supportsPartitioning() {
        return false;
    }

    public String getCompatibleLevel() {
        return null;
    }

    @Override
    protected Schema createSchema(Connection connection) {
        try {
            return this.createSchema(connection.getMetaData().getUserName());
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    protected boolean isSupportedType(String string) {
        return OracleLite.isOLiteType(string);
    }

    static boolean isOLiteType(String string) {
        for (int i = 0; i < OLITE_OBJECT_TYPES.length; ++i) {
            if (!OLITE_OBJECT_TYPES[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSystemPrivilege(String string, Schema schema, String string2) {
        return schema.getName().equalsIgnoreCase("SYSTEM") || schema.getName().equals(this.getUserName());
    }

    public List<CompilationResults> submitDatabaseSources(String string, List<String> list) {
        throw new UnsupportedOperationException();
    }

    public CompilationResults submitDatabaseSource(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public List<CompilationResults> getCompilationResults(List<PlSqlIdentifier> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void initSessionParameterQueryMap(Map<String, String> map) {
    }

    public Database createStandaloneDatabase(Schema schema) throws DBException {
        return null;
    }
}

