/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.math.BigInteger;
import java.util.Collection;
import oracle.javatools.db.AutoExtendProperties;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class OracleTablespacePropertiesValidator
extends AbstractChildDBObjectValidator<OracleTablespaceProperties> {
    private static Integer n1 = new Integer(1);

    public OracleTablespacePropertiesValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("logging");
        collection.add("onlineStatus");
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"minExtent"}, level=ValidationLevel.FULL)
    public void validateMinExtent(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        Integer n = oracleTablespaceProperties2.getMinExtent();
        if (n != null && n < 1) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"MINEXTENT", n1}));
        }
        OracleTablespaceProperties.ExtentManagementType extentManagementType = oracleTablespaceProperties2.getExtentManagementType();
        if (n != null && extentManagementType != null && extentManagementType != OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_MIN_EXTENT_NOT_DICT"));
        }
        this.validateNonNullableProperty((DBObject)oracleTablespaceProperties, (DBObject)oracleTablespaceProperties2, "minExtent");
    }

    @DBObjectValidator.PropertyValidator(value={"blockSize"}, level=ValidationLevel.FULL)
    public void validateBlockSize(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        Integer n = oracleTablespaceProperties2.getBlockSize();
        if (n != null && n < 1) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"MINEXTENT", n1}));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"forceLogging"}, level=ValidationLevel.FULL)
    public void validateForceLogging(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        Tablespace tablespace;
        Tablespace.TablespaceType tablespaceType;
        boolean bl = oracleTablespaceProperties2.isForceLogging();
        if (oracleTablespaceProperties2.getParent() instanceof Tablespace && bl && (tablespaceType = (Tablespace.TablespaceType)(tablespace = (Tablespace)oracleTablespaceProperties2.getParent()).getProperty("TablespaceType")) != Tablespace.TablespaceType.PERMANENT) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_FORCE_LOG_NON_PERM"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"defaultTableCompression"}, level=ValidationLevel.FULL)
    public void validateDefaultTableCompression(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        OracleTablespaceProperties.ExtentManagementType extentManagementType;
        Tablespace.TablespaceType tablespaceType;
        OracleTableProperties.OracleTableCompression oracleTableCompression = oracleTablespaceProperties2.getDefaultTableCompression();
        if (oracleTablespaceProperties2.getParent() instanceof Tablespace && oracleTableCompression != null && (tablespaceType = (Tablespace.TablespaceType)(extentManagementType = (Tablespace)oracleTablespaceProperties2.getParent()).getProperty("TablespaceType")) == Tablespace.TablespaceType.TEMPORARY) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_DEF_COMPRESS_FOR_TEMP"));
        }
        extentManagementType = oracleTablespaceProperties2.getExtentManagementType();
        if (oracleTableCompression != null && oracleTableCompression != OracleTableProperties.OracleTableCompression.COMPRESS && extentManagementType == OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_DEF_COMPRESS_NON_DICT"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"autoAllocate"}, level=ValidationLevel.FULL)
    public void validateAutoAllocate(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        Tablespace tablespace;
        Tablespace.TablespaceType tablespaceType;
        boolean bl = oracleTablespaceProperties2.isAutoAllocate();
        Integer n = oracleTablespaceProperties2.getMinExtent();
        if (bl && n != null) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_MIN_EXTENT_AUTOALLOCATE"));
        }
        if (oracleTablespaceProperties2.getParent() instanceof Tablespace && bl && (tablespaceType = (Tablespace.TablespaceType)(tablespace = (Tablespace)oracleTablespaceProperties2.getParent()).getProperty("TablespaceType")) == Tablespace.TablespaceType.TEMPORARY) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_AUTOALLOCATE_TEMP"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"uniformSize"}, level=ValidationLevel.FULL)
    public void validateUniformSize(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        Tablespace tablespace;
        Tablespace.TablespaceType tablespaceType;
        BigInteger bigInteger = oracleTablespaceProperties2.getUniformSize();
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"UNIFORM SIZE", n1}));
        }
        if (oracleTablespaceProperties2.getParent() instanceof Tablespace && bigInteger != null && (tablespaceType = (Tablespace.TablespaceType)(tablespace = (Tablespace)oracleTablespaceProperties2.getParent()).getProperty("TablespaceType")) == Tablespace.TablespaceType.UNDO) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_UNIFORM_UNDO"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"extentManagementType"}, level=ValidationLevel.FULL)
    public void validateExtentManagement(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        OracleTablespaceProperties.ExtentManagementType extentManagementType = oracleTablespaceProperties2.getExtentManagementType();
        if (oracleTablespaceProperties2.getParent() instanceof Tablespace && extentManagementType != null) {
            Tablespace tablespace = (Tablespace)oracleTablespaceProperties2.getParent();
            Tablespace.TablespaceType tablespaceType = (Tablespace.TablespaceType)tablespace.getProperty("TablespaceType");
            if (oracleTablespaceProperties != null && extentManagementType != oracleTablespaceProperties.getExtentManagementType()) {
                throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_EXT_MGMNT_UPD"));
            }
            if (extentManagementType == OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
                if (tablespaceType == Tablespace.TablespaceType.TEMPORARY) {
                    throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_TEMP_DICT"));
                }
                if (tablespaceType == Tablespace.TablespaceType.UNDO) {
                    throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_UNDO_DICT"));
                }
                if (tablespace.getFileType() == Tablespace.FileType.BIGFILE) {
                    throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_BIG_FILE_DICT"));
                }
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"segmentManagement"}, level=ValidationLevel.FULL)
    public void validateSegmentManagement(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        Tablespace tablespace;
        Tablespace.TablespaceType tablespaceType;
        OracleTablespaceProperties.SegmentManagement segmentManagement = oracleTablespaceProperties2.getSegmentManagement();
        OracleTablespaceProperties.ExtentManagementType extentManagementType = oracleTablespaceProperties2.getExtentManagementType();
        if (oracleTablespaceProperties2.getParent() instanceof Tablespace && extentManagementType != null && segmentManagement == OracleTablespaceProperties.SegmentManagement.MANUAL && ((tablespaceType = (Tablespace.TablespaceType)(tablespace = (Tablespace)oracleTablespaceProperties2.getParent()).getProperty("TablespaceType")) != Tablespace.TablespaceType.PERMANENT && extentManagementType != OracleTablespaceProperties.ExtentManagementType.LOCAL || tablespace.getFileType() == Tablespace.FileType.BIGFILE)) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_MAN_SEG_MGMNT"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"tablespaceGroup"}, level=ValidationLevel.FULL)
    public void validateTablespaceGroup(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        Tablespace tablespace;
        Tablespace.TablespaceType tablespaceType;
        String string = oracleTablespaceProperties2.getTablespaceGroup();
        if (oracleTablespaceProperties2.getParent() instanceof Tablespace && string != null && (tablespaceType = (Tablespace.TablespaceType)(tablespace = (Tablespace)oracleTablespaceProperties2.getParent()).getProperty("TablespaceType")) != Tablespace.TablespaceType.TEMPORARY) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_TBSP_GRP_NON_TEMP"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"retention"}, level=ValidationLevel.FULL)
    public void validateRetention(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        Tablespace tablespace;
        Tablespace.TablespaceType tablespaceType;
        OracleTablespaceProperties.RetentionType retentionType = oracleTablespaceProperties2.getRetention();
        if (oracleTablespaceProperties2.getParent() instanceof Tablespace && retentionType != null && (tablespaceType = (Tablespace.TablespaceType)(tablespace = (Tablespace)oracleTablespaceProperties2.getParent()).getProperty("TablespaceType")) != Tablespace.TablespaceType.UNDO) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_RETENT_NON_UNDO"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"autoExtendProperties"}, level=ValidationLevel.FULL)
    public void validateAutoExtend(OracleTablespaceProperties oracleTablespaceProperties, OracleTablespaceProperties oracleTablespaceProperties2) throws ValidationException {
        Tablespace tablespace;
        AutoExtendProperties autoExtendProperties = oracleTablespaceProperties2.getAutoExtendProperties();
        if (oracleTablespaceProperties2.getParent() instanceof Tablespace && autoExtendProperties != null && (tablespace = (Tablespace)oracleTablespaceProperties2.getParent()).getFileType() != Tablespace.FileType.BIGFILE) {
            throw new ValidationException((DBObject)oracleTablespaceProperties2, APIBundle.get((String)"TABLESPACE_ERROR_AUTOEXTEND_SMALLFILE"));
        }
    }
}

