/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlCodeFragment;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.PlSqlParameter;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlStatement;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.PlSqlVariable;
import oracle.javatools.db.plsql.parser.AbstractPlSqlBuilder;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.token.Token;

public class PlSqlFragmentBuilder<T extends PlSqlCodeFragment>
extends AbstractPlSqlBuilder<T> {
    public PlSqlFragmentBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
        super(abstractDBObjectProvider, string);
    }

    @Override
    public PlSqlParser getParser(T t) throws CancelledException {
        PlSqlParser plSqlParser = null;
        PlSqlSourceObject plSqlSourceObject = this.getSourceObject((DBObjectPlSqlFragment)t);
        if (plSqlSourceObject != null) {
            plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)plSqlSourceObject, (DBObjectProvider)this.getProvider());
        }
        return plSqlParser;
    }

    protected Executor getPropertyExecutor(T t) {
        PlSqlSourceObject plSqlSourceObject = this.getSourceObject((DBObjectPlSqlFragment)t);
        Executor executor = plSqlSourceObject instanceof AbstractBuildableObject ? PlSqlFragmentBuilder.getPropertyExecutorForObject((AbstractBuildableObject)((AbstractBuildableObject)plSqlSourceObject)) : super.getPropertyExecutor(t);
        return executor;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"source"}, derived=true)
    public boolean buildChildObjectProperties(T t) throws DBException {
        PlSqlParser plSqlParser = this.getParser(t);
        if (plSqlParser != null && t.getStartOffset() != null) {
            if (t instanceof PlSqlSubProgram) {
                this.buildPlSqlSubProgram((PlSqlSubProgram)t, plSqlParser);
            } else if (t instanceof PlSqlParameter) {
                this.buildPlSqlParameter((PlSqlParameter)t, plSqlParser);
            } else if (t instanceof PlSqlVariable) {
                this.buildPlSqlVariable((PlSqlVariable)t, plSqlParser);
            } else if (t instanceof PlSqlDatatype) {
                this.buildPlSqlDatatype((PlSqlDatatype)t, plSqlParser);
            }
            boolean bl = false;
            Class<?> clazz = t.getClass();
            if ("STATEMENT".equals(t.getType()) && PlSqlStatement.Type.STATEMENT.equals((Object)((PlSqlStatement)t).getStatementType())) {
                bl = false;
            } else {
                for (String string : this.getBuiltProperties("propertyReferences")) {
                    Class clazz2;
                    PropertyInfo propertyInfo = PropertyHelper.findPropertyInfo(clazz, (String)string, (DBObjectProvider)null);
                    if (propertyInfo == null || !propertyInfo.isDerived() || !(clazz2 = propertyInfo.getPropertyClass()).isArray() || !DBObjectPlSqlFragment.class.isAssignableFrom(clazz2.getComponentType()) || !DBUtil.needsBuilding(t, (String)string)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.checkInterruptOrCancel((AbstractBuildableObject)t);
                Object object = plSqlParser.getParseNode(t);
                if (object != null) {
                    this.addChildren(object, t, plSqlParser);
                }
            }
        }
        return true;
    }

    private void buildPlSqlVariable(PlSqlVariable plSqlVariable, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlToken plSqlToken;
        PlSqlSearch plSqlSearch = new PlSqlSearch("<var ?> [CONSTANT] <datatype ?%>");
        PlSqlToken plSqlToken2 = plSqlParser.getTokenAtOffset(plSqlVariable.getStartOffset().intValue());
        if (plSqlSearch.matches(plSqlToken2, plSqlToken = plSqlParser.getTokenAtOffset(plSqlVariable.getEndOffset().intValue()))) {
            plSqlToken2 = plSqlSearch.getNamedMatchStartToken("datatype");
            plSqlToken = plSqlSearch.getNamedMatchEndToken("datatype");
            PlSqlReference plSqlReference = this.findDataTypeReference(plSqlToken2, plSqlToken, "1", plSqlParser);
            plSqlVariable.setDataTypeReference(plSqlReference);
            plSqlToken2 = (PlSqlToken)plSqlToken.getNextCodeToken();
            if (plSqlToken2.getStart() < plSqlVariable.getEndOffset()) {
                plSqlToken = plSqlParser.getTokenAtOffset(plSqlVariable.getEndOffset().intValue());
                ArrayList<PlSqlToken> arrayList = new ArrayList<PlSqlToken>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                this.buildNameAndTokenLists(plSqlToken2, plSqlToken, true, arrayList, arrayList2, plSqlParser);
                if (!arrayList.isEmpty()) {
                    int n = arrayList.size() - 1;
                    this.buildReference(plSqlParser, (PlSqlCodeFragment)plSqlVariable, arrayList2, ((PlSqlToken)arrayList.get(0)).getStart(), ((PlSqlToken)arrayList.get(n)).getEnd(), true);
                }
            }
        }
    }

    private void buildPlSqlDatatype(PlSqlDatatype plSqlDatatype, PlSqlParser plSqlParser) throws CancelledException {
        PlSqlSearch plSqlSearch = new PlSqlSearch("<type {TYPE|SUBTYPE}> <name ?> IS <structure ?>");
        PlSqlToken plSqlToken = plSqlParser.getTokenAtOffset(plSqlDatatype.getStartOffset().intValue());
        if (plSqlSearch.matches(plSqlToken)) {
            PlSqlDatatype.Structure structure;
            plSqlDatatype.setSubType(plSqlSearch.getNamedMatch("type").equals("SUBTYPE"));
            String string = this.getProvider().getInternalName(plSqlSearch.getNamedMatch("name"));
            try {
                structure = PlSqlDatatype.Structure.valueOf((String)plSqlSearch.getNamedMatch("structure"));
            }
            catch (Exception exception) {
                structure = PlSqlDatatype.Structure.SCALAR;
            }
            plSqlDatatype.setStructure(structure);
            plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
            if (structure != PlSqlDatatype.Structure.RECORD) {
                Object object;
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                if (structure == PlSqlDatatype.Structure.TABLE) {
                    plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken(2);
                } else if (structure == PlSqlDatatype.Structure.VARRAY) {
                    plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken(3);
                    object = null;
                    try {
                        object = Integer.valueOf(plSqlToken.getSource());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    plSqlDatatype.setLimit((Integer)object);
                    plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken(2);
                }
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                for (object = plSqlParser.getTokenAtOffset(plSqlDatatype.getEndOffset().intValue()); object != plSqlToken && object.getType() == Token.Type.PUNCTUATION && !object.matches(")"); object = (PlSqlToken)object.getPrevCodeToken()) {
                }
                PlSqlReference plSqlReference = this.findDataTypeReference(plSqlToken, (PlSqlToken)object, "baseTypeOffset", plSqlParser);
                plSqlDatatype.addPropertyReference(plSqlReference);
                plSqlDatatype.setBaseTypeOffset(plSqlReference.getStartOffset());
            }
        }
    }

    private PlSqlSourceObject getSourceObject(DBObjectPlSqlFragment dBObjectPlSqlFragment) {
        PlSqlSourceObject plSqlSourceObject = null;
        SchemaObject schemaObject = DBUtil.getSchemaObject((DBObject)dBObjectPlSqlFragment);
        if (schemaObject instanceof PlSqlSourceObject) {
            plSqlSourceObject = (PlSqlSourceObject)schemaObject;
        }
        return plSqlSourceObject;
    }
}

