/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.util.Properties;
import oracle.security.digsig.BrowserSignRequest;
import oracle.security.digsig.CRLValidator;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.KeyStoreWrapper;
import oracle.security.digsig.PKCS7BrowserSignRequest;
import oracle.security.digsig.PKCS7Signer;
import oracle.security.digsig.PKCS7Verifier;
import oracle.security.digsig.SPIBrowserSignRequest;
import oracle.security.digsig.SPIValidator;
import oracle.security.digsig.SPIVerifier;
import oracle.security.digsig.Signer;
import oracle.security.digsig.Validator;
import oracle.security.digsig.ValidatorStore;
import oracle.security.digsig.Verifier;

public class DigitalSignatureManager {
    public static final String PKCS7_BSR_PROVIDER_KEY = "oracle.security.digsig.browsersignrequest.provider.PKCS7";
    public static final String PKCS7_VERIFIER_PROVIDER_KEY = "oracle.security.digsig.verifier.provider.PKCS7";
    public static final String EXTERNAL_BSR_PROVIDER_KEY = "oracle.security.digsig.browsersignrequest.provider.EXTERNAL";
    public static final String EXTERNAL_VERIFIER_PROVIDER_KEY = "oracle.security.digsig.verifier.provider.EXTERNAL";
    public static final String DEFAULT_VALIDATOR_MODE_KEY = "oracle.security.digsig.validator.mode.default";
    public static final String CRL_VALIDATOR_PROVIDER_KEY = "oracle.security.digsig.validator.provider.CRL";
    public static final String EXTERNAL_VALIDATOR_PROVIDER_KEY = "oracle.security.digsig.validator.provider.EXTERNAL";
    private KeyStoreWrapper dsmKeyStore;
    private Properties dsmConfig;
    private CertificateMapper dsmCertificateMapper;

    public DigitalSignatureManager(KeyStoreWrapper pKeyStore, CertificateMapper pCertificateMapper, Properties pConfig) throws DigitalSignatureException {
        this.dsmKeyStore = pKeyStore;
        this.dsmCertificateMapper = pCertificateMapper;
        this.dsmConfig = pConfig;
    }

    public void setConfiguration(Properties pConfig) {
        this.dsmConfig = pConfig;
    }

    public Properties getConfiguration() {
        return this.dsmConfig;
    }

    public Signer getSigner(int pSignatureFormat) throws DigitalSignatureException {
        if (pSignatureFormat != 2) {
            throw new DigitalSignatureException("Unsupported signature format");
        }
        PKCS7Signer s = new PKCS7Signer(this.dsmKeyStore, this.dsmCertificateMapper, this.dsmConfig);
        return s;
    }

    public Verifier getVerifier(int pSignatureFormat) throws DigitalSignatureException {
        Verifier v = null;
        boolean noProvider = false;
        if (pSignatureFormat != 2 && pSignatureFormat != -1) {
            throw new DigitalSignatureException("Unsupported signature format");
        }
        switch (pSignatureFormat) {
            case 2: {
                String pVal;
                if (this.dsmConfig == null || (pVal = this.dsmConfig.getProperty(PKCS7_VERIFIER_PROVIDER_KEY)) == null) {
                    noProvider = true;
                } else {
                    v = new SPIVerifier(this.dsmKeyStore, this.dsmCertificateMapper, this.dsmConfig, pVal);
                }
                if (!noProvider) break;
                v = new PKCS7Verifier(this.dsmKeyStore, this.dsmCertificateMapper, this.dsmConfig);
                break;
            }
            case -1: {
                String pVal;
                if (this.dsmConfig == null || (pVal = this.dsmConfig.getProperty(EXTERNAL_VERIFIER_PROVIDER_KEY)) == null) {
                    throw new DigitalSignatureException("No EXTERNAL provider for verifier configured");
                }
                v = new SPIVerifier(this.dsmKeyStore, this.dsmCertificateMapper, this.dsmConfig, pVal);
                break;
            }
        }
        return v;
    }

    public BrowserSignRequest getBrowserSignRequest(int pSignatureFormat) throws DigitalSignatureException {
        BrowserSignRequest b = null;
        boolean noProvider = false;
        if (pSignatureFormat != 2 && pSignatureFormat != -1) {
            throw new DigitalSignatureException("Unsupported signature format");
        }
        switch (pSignatureFormat) {
            case 2: {
                String pVal;
                if (this.dsmConfig == null || (pVal = this.dsmConfig.getProperty(PKCS7_BSR_PROVIDER_KEY)) == null) {
                    noProvider = true;
                } else {
                    b = new SPIBrowserSignRequest(this.dsmCertificateMapper, this.dsmConfig, pVal);
                }
                if (!noProvider) break;
                b = new PKCS7BrowserSignRequest(this.dsmCertificateMapper, this.dsmConfig);
                break;
            }
            case -1: {
                String pVal;
                if (this.dsmConfig == null || (pVal = this.dsmConfig.getProperty(EXTERNAL_BSR_PROVIDER_KEY)) == null) {
                    throw new DigitalSignatureException("No EXTERNAL provider for browser sign request configured");
                }
                b = new SPIBrowserSignRequest(this.dsmCertificateMapper, this.dsmConfig, pVal);
            }
        }
        return b;
    }

    public Validator getValidator(ValidatorStore pValidatorStore) throws DigitalSignatureException {
        String pMode;
        Validator v = null;
        boolean noProvider = false;
        if (this.dsmConfig == null || (pMode = this.dsmConfig.getProperty(DEFAULT_VALIDATOR_MODE_KEY)) == null) {
            throw new DigitalSignatureException("Default Validation Mode not configured");
        }
        int pValidationMode = (pMode = pMode.toLowerCase()).equals("crl") ? 1 : (pMode.equals("ocsp") ? 2 : (pMode.equals("xkms") ? 3 : (pMode.equals("external") ? -1 : -2)));
        switch (pValidationMode) {
            case 1: {
                String pVal;
                if (this.dsmConfig == null || (pVal = this.dsmConfig.getProperty(CRL_VALIDATOR_PROVIDER_KEY)) == null) {
                    noProvider = true;
                } else {
                    v = new SPIValidator(this.dsmKeyStore, this.dsmCertificateMapper, pValidatorStore, this.dsmConfig, pVal);
                }
                if (!noProvider) break;
                v = new CRLValidator(this.dsmKeyStore, this.dsmCertificateMapper, pValidatorStore, this.dsmConfig);
                break;
            }
            case -1: {
                String pVal;
                if (this.dsmConfig == null || (pVal = this.dsmConfig.getProperty(EXTERNAL_VALIDATOR_PROVIDER_KEY)) == null) {
                    throw new DigitalSignatureException("No EXTERNAL provider for validator configured");
                }
                v = new SPIValidator(this.dsmKeyStore, this.dsmCertificateMapper, pValidatorStore, this.dsmConfig, pVal);
                break;
            }
            default: {
                throw new DigitalSignatureException("Unsupported Validation Mode");
            }
        }
        return v;
    }
}

