/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import oracle.security.crypto.cert.X509;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.KeyStoreWrapper;
import oracle.security.digsig.ValidatorProperties;
import oracle.security.digsig.ValidatorStore;

public abstract class Validator {
    public static final int VALID = 0;
    public static final int REVOKED = -1;
    public static final int WAIT = -2;
    public static final int UNKNOWN = -3;
    protected Properties validatorConfig;
    protected KeyStore validatorKeyStore;
    protected ValidatorStore validatorStore;
    protected HashMap validatorTrustPoints;
    protected CertificateMapper validatorCertificateMapper;

    Validator() {
    }

    Validator(KeyStoreWrapper pKeyStore, CertificateMapper pCertMapper, ValidatorStore pValidatorStore, Properties pConfig) throws DigitalSignatureException {
        if (pKeyStore == null) {
            throw new DigitalSignatureException("KeyStore parameter is mandatory");
        }
        this.validatorKeyStore = pKeyStore.getKeyStore();
        this.validatorConfig = pConfig;
        this.validatorCertificateMapper = pCertMapper;
        this.validatorStore = pValidatorStore;
        try {
            this.validatorTrustPoints = new HashMap();
            Enumeration<String> keyStoreTrustPointAliases = this.validatorKeyStore.aliases();
            while (keyStoreTrustPointAliases.hasMoreElements()) {
                String alias = keyStoreTrustPointAliases.nextElement();
                if (!this.validatorKeyStore.isCertificateEntry(alias)) continue;
                X509Certificate jdkCert = (X509Certificate)this.validatorKeyStore.getCertificate(alias);
                X509 phaosCert = new X509((InputStream)new ByteArrayInputStream(jdkCert.getEncoded()));
                this.validatorTrustPoints.put(phaosCert.getSubject(), phaosCert);
            }
            if (this.validatorTrustPoints.size() == 0) {
                throw new DigitalSignatureException("No trusted certificates in key store");
            }
        }
        catch (Exception e) {
            throw new DigitalSignatureException("Internal error - " + e);
        }
    }

    public abstract int getValidationMode();

    public abstract ValidatorProperties getValidatorProperties() throws DigitalSignatureException;

    public abstract int validateCert(String var1, Date var2) throws DigitalSignatureException;
}

