/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.dss.dataView.ViewFormatHandle;
import oracle.dss.dataView.ViewStyleHandle;
import oracle.dss.util.AbstractMap;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Map {
    private String m_nodeName;
    private AbstractMap m_map;
    private AbstractMap m_expectedMap;
    private Hashtable m_readMap;
    public static final String ENTRY = "Entry";
    public static final String ID = "id";
    public static final String PARAM = "a";
    public static final String TYPE = "type";

    public Map(String name, AbstractMap expectedMap) {
        this(name, null, expectedMap);
    }

    public Map(String name, AbstractMap map, AbstractMap expectedMap) {
        this.m_nodeName = name;
        this.m_map = map;
        this.m_expectedMap = expectedMap;
    }

    public void setExpectedMap(AbstractMap map) {
        this.m_expectedMap = map;
    }

    public AbstractMap getExpectedMap() {
        return this.m_expectedMap;
    }

    public AbstractMap getSupportedMap() {
        return this.m_map;
    }

    public void setSupportedMap(AbstractMap map) {
        this.m_map = (AbstractMap)this.m_expectedMap.clone();
        Enumeration types = this.m_map.types();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            if (map.containsType(type) != -1) continue;
            this.m_map.removeType(type);
        }
    }

    private void clear() {
        this.m_readMap = new Hashtable();
        try {
            this.m_map = (AbstractMap)this.m_expectedMap.getClass().newInstance();
        }
        catch (Exception e) {
            this.m_map = null;
        }
    }

    public void readMapFromXML(ObjectNode node) {
        this.clear();
        ContainerNode cnt = node.getContainer(this.m_nodeName);
        if (cnt == null) {
            return;
        }
        Enumeration entries = cnt.getContainedObject(ENTRY);
        while (entries.hasMoreElements()) {
            ObjectNode entry = (ObjectNode)entries.nextElement();
            try {
                int id = entry.getPropertyValueAsInteger(ID);
                String type = entry.getPropertyValueAsString(TYPE);
                if (id < 0) continue;
                this.m_map.addType(type);
                this.m_readMap.put(type, this.getParamName(id));
            }
            catch (NoSuchPropertyException noSuchPropertyException) {}
        }
    }

    public void addMapToXML(ObjectNode node) {
        ContainerNode cnt = new ContainerNode(this.m_nodeName);
        Enumeration types = this.getSupportedMap().types();
        int id = 0;
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            ObjectNode entry = new ObjectNode(ENTRY);
            entry.addProperty(ID, id++);
            entry.addProperty(TYPE, type);
            cnt.addContainedObject((BaseNode)entry);
        }
        node.addContainer(cnt);
    }

    public Object readDataFromXML(BaseObjectNode node, String type) {
        String id = (String)this.m_readMap.get(type);
        if (id == null) {
            return null;
        }
        String ret = null;
        if ((type.equals("dataViewStyle") || type.equals("viewStyle") || type.equals("viewStyle")) && node instanceof ObjectNode) {
            ObjectNode style = ((ObjectNode)node).getPropertyValueAsObjectNode(id, true);
            if (style != null) {
                ViewStyleHandle handle = new ViewStyleHandle();
                handle.setXML(style);
                ret = handle;
            }
        } else if (type.equals("dataViewFormat") && node instanceof ObjectNode) {
            ObjectNode format = ((ObjectNode)node).getPropertyValueAsObjectNode(id, true);
            if (format != null) {
                ViewFormatHandle handle = new ViewFormatHandle();
                handle.setXML(format);
                ret = handle;
            }
        } else {
            PropertyNode val = node.getProperty(id);
            if (val != null) {
                ret = val.getValueAsString();
            }
        }
        return ret;
    }

    public Enumeration types() {
        return this.getSupportedMap().types();
    }

    public void addDataToXML(BaseObjectNode node, String type, Object val) {
        if (val == null) {
            return;
        }
        int id = this.getSupportedMap().indexOf((Object)type);
        if (id < 0) {
            return;
        }
        if ((type.equals("dataViewStyle") || type.equals("viewStyle") || type.equals("viewStyle")) && node instanceof ObjectNode && val instanceof ViewStyleHandle) {
            ObjectNode props = ((ViewStyleHandle)val).getXML(this.getParamName(id), false);
            if (props != null) {
                ((ObjectNode)node).addProperty(props);
            }
        } else if (type.equals("dataViewFormat") && node instanceof ObjectNode && val instanceof ViewFormatHandle) {
            ObjectNode props = ((ViewFormatHandle)val).getXML(this.getParamName(id), false);
            if (props != null) {
                ((ObjectNode)node).addProperty(props);
            }
        } else {
            node.addProperty(this.getParamName(id), val.toString());
        }
    }

    private String getParamName(int i) {
        return PARAM + String.valueOf(i);
    }
}

