/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Window;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.quickav.QuickAVDialog;
import oracle.hcs.util.SourceSelectionDialog;
import oracle.ide.Ide;

public class QuickAVAction
extends AbstractMenuAction {
    private static final String SOURCE_QUERIES = "sourcequeries.xml";
    private SourceMetadata sourceMetadata;
    private QuickAVDialog dialog;
    private HCSSchema schema;
    private List<DatabaseSource> dbSources;

    public void launch() {
        String string = HCSArb.getString("QUICK_AV_DIALOG_LOADING");
        RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    if (QuickAVAction.this.dbSources != null && !QuickAVAction.this.dbSources.isEmpty()) {
                        QuickAVAction.this.dialog = new QuickAVDialog(QuickAVAction.this.getDBObject(), QuickAVAction.this.schema, QuickAVAction.this.sourceMetadata, QuickAVAction.this.dbSources);
                    }
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    Logger.getLogger(QuickAVAction.class.getName()).log(Level.SEVERE, HCSArb.getString("QUICK_AV_DIALOG_LOADING_ERROR"), exception);
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        Logger.getLogger(this.getClass().getName()).severe(throwable.toString());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (QuickAVAction.this.dialog != null) {
                            QuickAVAction.this.dialog.setModal(true);
                            QuickAVAction.this.dialog.setVisible(true);
                            QuickAVAction.this.setBlockOACRefresh(true);
                            if (QuickAVAction.this.dialog.isAVCreated()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        QuickAVAction.this.refreshNavigator();
                                    }
                                });
                            }
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        try {
            this.sourceMetadata = new SourceMetadata(SOURCE_QUERIES, this.getDBObject().getConnection());
            this.schema = HCSMetadataCache.getUpdatedSchema(this.getDBObject().getConnectionName(), this.getDBObject().getSchemaName());
            this.dbSources = SourceSelectionDialog.showDialog((Window)Ide.getMainWindow(), this.sourceMetadata, null, this.schema.getName(), "", "", true, false, "av_source_selection");
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }
        catch (Exception exception) {
            Logger.getLogger(QuickAVAction.class.getName()).log(Level.SEVERE, HCSArb.getString("QUICK_AV_DIALOG_LOADING_ERROR"), exception);
        }
    }

    private void refreshNavigator() {
        ObjectAction objectAction = new ObjectAction();
        objectAction.setReloadParent(true);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)this.getDBObject());
        objectActionPostProcess.run();
    }
}

