/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.panels.HCSDDLPanel;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.quickav.QuickAVDimensionGenerator;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;

public class AVDDL {
    private List<AttributeDimension> dimensions;
    private List<AVMeasure> measures;
    private String analyticViewName;
    private DatabaseSource factTable;
    private HCSSchema schema;
    private Database db;
    private static final String MEASURE_DEFAULT_AGG = "SUM";
    private static final String VIEW_NAME_KEY = "VIEW_NAME";
    private static final String DATA_TYPE_KEY = "DATA_TYPE_KEY";
    private static final String DIM_ATTR_NAME = "DIM_ATTR_NAME";
    private List<String> ddlStatements;
    private List<MetadataChange> metadataChanges;
    private QuickAVDimensionGenerator dimGen;
    private static final String QUICK_AV_SOURCE_STS_SQL_VIEWS_HEADER_COMMENTS = "/* - - - - - - - - - - - - - - - - - - - - - VIEWS - - - - - - - - - - - - - - - - - - - - */";
    private static final String QUICK_AV_SOURCE_STS_SQL_DIMENSIONS_HEADER_COMMENTS = "/* - - - - - - - - - - - - - - - - - ATTRIBUTE DIMENSIONS - - - - - - - - - - - - - - - - - */";
    private static final String QUICK_AV_SOURCE_STS_SQL_AVS_HEADER_COMMENTS = "/* - - - - - - - - - - - - - - - - - - - ANALYTIC VIEW - - - - -  - - - - - - - - - - - - */";
    private static final String QUICK_AV_SOURCE_STS_SQL_VIEW_COMMENT = "-- %s view";
    private static final String QUICK_AV_SOURCE_STS_SQL_DIMENSION_COMMENT = "-- %s attribute dimension";
    private static final String QUICK_AV_SOURCE_STS_SQL_HIERARCHY_COMMENT = "-- %s hierarchy";
    private static final String QUICK_AV_SOURCE_STS_SQL_AV_COMMENT = "-- %s analytic view";
    private static final Logger LOG = Logger.getLogger(AVDDL.class.getName());

    public AVDDL(HCSSchema hCSSchema, Database database, String string, DatabaseSource databaseSource, QuickAVDimensionGenerator quickAVDimensionGenerator) {
        this.analyticViewName = string;
        this.factTable = databaseSource;
        this.schema = hCSSchema;
        this.db = database;
        this.dimensions = new ArrayList<AttributeDimension>();
        this.measures = new ArrayList<AVMeasure>();
        this.ddlStatements = new ArrayList<String>();
        this.metadataChanges = new ArrayList<MetadataChange>();
        this.dimGen = quickAVDimensionGenerator;
    }

    public void setAvName(String string) {
        this.analyticViewName = string;
    }

    public void setFactTableSource(DatabaseSource databaseSource) {
        this.factTable = databaseSource;
        this.dimGen.initializeConstraintsSet(this.factTable);
    }

    public void clear() {
        this.dimensions.clear();
        this.measures.clear();
        this.ddlStatements.clear();
        this.metadataChanges.clear();
        this.dimGen.clear();
    }

    public List<MetadataChange> generateMetadataChanges() {
        this.metadataChanges.clear();
        for (AttributeDimension abstractMappableSchemaObjectWithDesc : this.dimensions) {
            if (this.schema.findDimension(abstractMappableSchemaObjectWithDesc.getName()) != null) continue;
            this.metadataChanges.add(new MetadataChange(abstractMappableSchemaObjectWithDesc.getName(), abstractMappableSchemaObjectWithDesc.getName(), HCSSyntaxType.DIMENSION));
        }
        for (Hierarchy hierarchy : this.dimGen.getAllHierarchies()) {
            if (this.schema.findHierarchy(hierarchy.getName()) != null) continue;
            this.metadataChanges.add(new MetadataChange(hierarchy.getName(), hierarchy.getName(), HCSSyntaxType.HIERARCHY));
        }
        return this.metadataChanges;
    }

    public void addDimension(String string, String string2, String string3) {
        this.addDimension(string, string2, false, string3);
    }

    public void addDimensionDistinct(String string, String string2) {
        AttributeDimension attributeDimension = this.dimGen.createNewDimensionDistinct(string, string2);
        this.dimensions.add(attributeDimension);
    }

    public void addDimension(String string, String string2, boolean bl, String string3) {
        AttributeDimension attributeDimension = null;
        attributeDimension = bl ? this.dimGen.createNewDimension(string, string3, true) : this.dimGen.findDimensionFromSchema(string, string2, string3);
        this.dimensions.add(attributeDimension);
    }

    private void setDescriptions(Descriptions descriptions, String string) {
        descriptions.setDescription(string);
        descriptions.setCaption(string);
    }

    public void addMeasure(String string, String string2) {
        AVMeasure aVMeasure = new AVMeasure(string);
        aVMeasure.setMapExpression(string);
        aVMeasure.setConsistentSolveSpec(MEASURE_DEFAULT_AGG);
        aVMeasure.setMeasureFormat(null);
        aVMeasure.setProperty(VIEW_NAME_KEY, string);
        aVMeasure.setProperty(DATA_TYPE_KEY, string2);
        this.setDescriptions(aVMeasure, string);
        this.measures.add(aVMeasure);
    }

    public List<String> generateDDL(boolean bl) {
        this.ddlStatements.clear();
        if (this.dimGen.getViewsCount() > 0) {
            this.ddlStatements.add(QUICK_AV_SOURCE_STS_SQL_VIEWS_HEADER_COMMENTS);
            this.createViewsDDL();
            this.ddlStatements.add(QUICK_AV_SOURCE_STS_SQL_DIMENSIONS_HEADER_COMMENTS);
        }
        for (AttributeDimension object2 : this.dimensions) {
            if (this.schema.findDimension(object2.getName()) != null) continue;
            this.ddlStatements.add(String.format(QUICK_AV_SOURCE_STS_SQL_DIMENSION_COMMENT, object2.getName()));
            this.createDimensionDDL(object2);
        }
        AnalyticView analyticView = new AnalyticView(this.schema, this.analyticViewName);
        this.setDescriptions(analyticView, UIStringUtils.stripDoubleQuotes(this.analyticViewName));
        analyticView.setavSourceTableOwner(this.factTable.getSchemaName());
        analyticView.setavSourceTable(this.factTable.getName());
        for (AttributeDimension attributeDimension : this.dimensions) {
            Object object;
            Object object2;
            AVDimensionality aVDimensionality = new AVDimensionality(attributeDimension);
            if (this.schema.findDimension(attributeDimension.getName()) != null) {
                object2 = this.schema.findHierarchies(attributeDimension.getName());
                boolean bl2 = false;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Hierarchy hierarchy = (Hierarchy)iterator.next();
                    AVHierarchy aVHierarchy = new AVHierarchy(hierarchy);
                    if (!bl2) {
                        aVHierarchy.setHierarchyDefault(Boolean.TRUE);
                        bl2 = true;
                    } else {
                        aVHierarchy.setHierarchyDefault(Boolean.FALSE);
                    }
                    aVHierarchy.setHierarchyIncluded(Boolean.TRUE);
                    aVDimensionality.addHierarchy(aVHierarchy);
                }
            } else {
                object2 = this.dimGen.getHierarchy((String)attributeDimension.getProperty(VIEW_NAME_KEY));
                object = new AVHierarchy((Hierarchy)object2);
                ((AVHierarchy)object).setHierarchyDefault(Boolean.TRUE);
                ((AVHierarchy)object).setHierarchyIncluded(Boolean.TRUE);
                aVDimensionality.addHierarchy((AVHierarchy)object);
            }
            object2 = (String)attributeDimension.getProperty("dimensionAlias");
            if (object2 == null) {
                object2 = attributeDimension.getName();
            }
            aVDimensionality.setDimensionAlias((String)object2);
            aVDimensionality.setDimensionalityName(attributeDimension.getName());
            aVDimensionality.setMapExpressions(new String[]{(String)attributeDimension.getProperty(VIEW_NAME_KEY)});
            object = this.findLeafAttribute(aVDimensionality);
            if (object != null) {
                aVDimensionality.setMappedDimensions(new String[]{object});
            } else if (attributeDimension.getProperty(DIM_ATTR_NAME) != null) {
                aVDimensionality.setMappedDimensions(new String[]{(String)attributeDimension.getProperty(DIM_ATTR_NAME)});
            } else {
                aVDimensionality.setMappedDimensions(new String[]{(String)attributeDimension.getProperty(VIEW_NAME_KEY)});
            }
            if (bl) {
                aVDimensionality.setDistinct(bl);
            }
            analyticView.addDimensionality(aVDimensionality);
        }
        for (AVMeasure aVMeasure : this.measures) {
            aVMeasure.setAV(analyticView);
            analyticView.addMeasure(aVMeasure);
        }
        analyticView.setDefaultMeasure(this.measures.get(0).getName());
        this.ddlStatements.add(QUICK_AV_SOURCE_STS_SQL_AVS_HEADER_COMMENTS);
        this.ddlStatements.add(String.format(QUICK_AV_SOURCE_STS_SQL_AV_COMMENT, this.analyticViewName));
        Collection<String> collection = this.generateDDLForObject(this.schema.findAV(analyticView.getName()), analyticView);
        this.addDDLStatements(collection);
        return this.ddlStatements;
    }

    private String findLeafAttribute(AVDimensionality aVDimensionality) {
        List<Hierarchy> list = this.schema.getHierarchies();
        DimensionLevel[] dimensionLevelArray = aVDimensionality.getSortedLevels(list);
        DimensionAttribute dimensionAttribute = aVDimensionality.getLeafAttribute(dimensionLevelArray);
        if (dimensionAttribute != null) {
            return dimensionAttribute.getName();
        }
        return null;
    }

    private void createViewsDDL() {
        for (AttributeDimension attributeDimension : this.dimensions) {
            String string = this.db.getExternalName(this.dimGen.getViewName((String)attributeDimension.getProperty(VIEW_NAME_KEY)));
            String string2 = this.db.getExternalName((String)attributeDimension.getProperty(VIEW_NAME_KEY));
            String string3 = String.format("\"%s\"", this.factTable.getName());
            if (!this.schema.getName().equals(this.factTable.getSchemaName())) {
                string3 = String.format("\"%s\".\"%s\"", this.factTable.getSchemaName(), this.factTable.getName());
            }
            if (string == null) continue;
            this.ddlStatements.add(String.format(QUICK_AV_SOURCE_STS_SQL_VIEW_COMMENT, string));
            String string4 = "";
            try {
                string4 = this.db.getDefaultSchema().getName().equalsIgnoreCase(attributeDimension.getSchema().getName()) ? String.format("create or replace view %s as select distinct %s from %s", string, string2, string3) : String.format("create or replace view \"%s\".%s as select distinct %s from %s", attributeDimension.getSchema().getName(), string, string2, string3);
            }
            catch (DBException dBException) {
                LOG.log(Level.WARNING, dBException.getLocalizedMessage(), dBException);
            }
            this.ddlStatements.add(string4);
        }
    }

    private void createDimensionDDL(AttributeDimension attributeDimension) {
        Collection<String> collection = this.generateDDLForObject(this.schema.findDimension(attributeDimension.getName()), attributeDimension);
        this.addDDLStatements(collection);
        Hierarchy hierarchy = this.dimGen.getHierarchy((String)attributeDimension.getProperty(VIEW_NAME_KEY));
        this.ddlStatements.add(String.format(QUICK_AV_SOURCE_STS_SQL_HIERARCHY_COMMENT, hierarchy.getName(), attributeDimension.getName()));
        collection = this.generateDDLForObject(this.schema.findHierarchy(hierarchy.getName()), hierarchy);
        this.addDDLStatements(collection);
    }

    private Collection<String> generateDDLForObject(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc, AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2) {
        DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig((DBObjectProvider)this.db, (DBObject)abstractSchemaObjectWithDesc2);
        dBEditorConfig.setUpdatedObject((SystemObject)abstractSchemaObjectWithDesc2);
        dBEditorConfig.setOriginalObject((SystemObject)abstractSchemaObjectWithDesc);
        dBEditorConfig.setReplaceAllowed(true);
        Collection<String> collection = HCSDDLPanel.getSQLStatements(dBEditorConfig);
        return collection;
    }

    private void addDDLStatements(Collection<String> collection) {
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.ddlStatements.add(iterator.next());
        }
    }

    public List<AVMeasure> getMeasures() {
        return this.measures;
    }

    public int getMeasuresCount() {
        return this.measures.size();
    }

    public int getDimensionsCount() {
        return this.dimensions.size();
    }

    public List<AttributeDimension> getDimensions() {
        return this.dimensions;
    }

    public Collection<Hierarchy> getHierarchies() {
        if (this.dimGen != null) {
            return this.dimGen.getAllHierarchies();
        }
        return Collections.emptyList();
    }
}

