/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.Condition;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class IsCondition
extends Condition {
    public static final String IS_NULL = "NULL";
    public static final String IS_NAN = "NAN";
    public static final String IS_INFINITE = "INFINITE";
    public static final String[] ALL_COMPARISONS = new String[]{"NULL", "NAN", "INFINITE"};
    private boolean m_Negated = false;
    private TypedExpression m_BaseExpression = null;
    private String m_Comparison = null;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getBaseExpression());
        if (this.isNegated()) {
            syntaxPrintingContext.append(" IS NOT ");
        } else {
            syntaxPrintingContext.append(" IS ");
        }
        syntaxPrintingContext.append(this.getComparison());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_BaseExpression = (TypedExpression)validationContext.validate(this.m_BaseExpression);
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getBaseExpression().isDefinitionComplete();
    }

    public IsCondition(TypedExpression typedExpression, String string, boolean bl) {
        IsCondition.validateValue(typedExpression);
        this.m_Comparison = IsCondition.validateEnum(string, ALL_COMPARISONS);
        this.m_Negated = bl;
        this.m_BaseExpression = typedExpression;
        this.initialize();
    }

    public IsCondition(TypedExpression typedExpression, boolean bl) {
        this(typedExpression, IS_NULL, bl);
    }

    public IsCondition(TypedExpression typedExpression) {
        this(typedExpression, IS_NULL, false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitIsCondition(this, object);
    }

    public String getComparison() {
        return this.m_Comparison;
    }

    public boolean isNegated() {
        return this.m_Negated;
    }

    public TypedExpression getBaseExpression() {
        return this.m_BaseExpression;
    }
}

