/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.details;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.db.Database;
import oracle.hcs.db.DatabaseImpl;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.hcs.syntaxbuilder.HCSSyntaxParser;
import oracle.hcs.syntaxbuilder.SyntaxBuilderLauncher;
import oracle.hcs.syntaxbuilder.details.CalculatedMeasureTablePanel;
import oracle.hcs.syntaxbuilder.details.CalculatedMeasureTableRefreshAction;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.icons.OracleIcons;

public abstract class AbstractCalculatedMeasureTable
extends Editor {
    private Node node;
    private URL url;
    private Database database;
    private HCSSyntaxParser parser;
    private String avName;
    private String measureName;
    private String connectionName;
    private String schemaName;
    private CalculatedMeasureTablePanel calculatedMeasureTable;
    private Toolbar toolbar;

    public void open() {
        this.init();
        this.calculatedMeasureTable = this.getCalculatedMeasureTable();
        IdeAction ideAction = IdeAction.findOrCreate((int)CalculatedMeasureTableRefreshAction.REFRESH_CALCULATED_MEASURE_TABLE, null, (String)HCSArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"), null, null, null, null, (boolean)true).newLocalAction((View)this);
        ideAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"refresh.png"));
        ideAction.addController((Controller)new CalculatedMeasureTableRefreshAction(this));
        Toolbar toolbar = this.getFixedTopMargin();
        if (toolbar.getComponentCount() == 0) {
            toolbar.add((ToggleAction)ideAction);
        }
    }

    public Toolbar getFixedTopMargin() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar();
        }
        return this.toolbar;
    }

    public Component getGUI() {
        return this.calculatedMeasureTable;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    protected void init() {
        this.node = this.getContext().getNode();
        this.url = this.node.getURL();
        this.connectionName = DBURLFormatHelper.getConnectionName((URL)this.url);
        this.schemaName = DBURLFormatHelper.getSchema((URL)this.url);
        this.loadAVAndMeasureName();
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
        }
        this.database = new DatabaseImpl();
        this.database.setConnection(connection);
        this.initializeOLAPISyntaxParser();
    }

    private void loadAVAndMeasureName() {
        if (this.node instanceof CalculatedMeasureNode) {
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)this.node;
            this.avName = calculatedMeasureNode.getAVName();
            this.measureName = calculatedMeasureNode.getMeasureName();
        }
    }

    protected Connection getConnection() throws DBException {
        return Connections.getInstance().getConnection(DBURLFormatHelper.getConnectionName((URL)this.url));
    }

    protected Database getDataBase() {
        return this.database;
    }

    private void initializeOLAPISyntaxParser() {
        HCSSchema hCSSchema = HCSMetadataCache.getSchema(this.connectionName, this.schemaName);
        Properties properties = new Properties();
        properties.setProperty("SCHEMA", hCSSchema.getName());
        properties.setProperty("CUBE", this.avName);
        this.parser = new HCSSyntaxParser(hCSSchema, properties);
    }

    protected String getSchemaName() {
        return DBURLFormatHelper.getSchema((URL)this.url);
    }

    protected HCSSchema getSchema() throws Exception {
        HCSSchema hCSSchema = HCSMetadataCache.getUpdatedSchema(this.connectionName, this.schemaName);
        return hCSSchema;
    }

    protected abstract CalculatedMeasureTablePanel getCalculatedMeasureTable();

    public void refresh() throws Exception {
        Properties properties = new Properties();
        HCSSchema hCSSchema = HCSMetadataCache.getSchema(this.connectionName, this.schemaName);
        hCSSchema.clear();
        SyntaxBuilderLauncher.populateSchema(hCSSchema, properties, null, this.database);
        List<? extends AbstractChildDBObject> list = this.getMeasuresList();
        this.calculatedMeasureTable.refresh(list);
    }

    protected abstract List<? extends AbstractChildDBObject> getMeasuresList() throws Exception;

    protected String getAVName() {
        return this.avName;
    }

    protected String getMeasureName() {
        return this.measureName;
    }

    protected HCSSyntaxParser getParser() {
        return this.parser;
    }
}

