/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.hcs.util.SourceValidationController;
import oracle.hcs.util.SourceValidator;

public class SourceTextField
extends JTextField {
    private boolean currentlyValid;
    private SourceValidationController controller;
    private Timer timer;
    private SourceValidator sourceValidator;

    public SourceTextField(SourceValidator sourceValidator) {
        this.sourceValidator = sourceValidator;
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SourceTextField.this.validateText();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SourceTextField.this.validateText();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SourceTextField.this.validateText();
            }
        });
        boolean bl = true;
        if (bl) {
            this.controller = new SourceValidationController(this);
            this.controller.setyOffset(20);
            this.controller.setXOffset(-120);
        }
    }

    public void validateText() {
        this.getTimer().restart();
    }

    public boolean isSourceValid() {
        return this.currentlyValid;
    }

    protected void showValidationMessage(String string) {
        if (this.controller != null) {
            this.controller.showError(string);
        }
    }

    public void showPopupMessage(String string) {
        if (this.controller != null) {
            this.controller.showTooltip(string, null);
        }
    }

    public void hidePopup() {
        if (this.controller != null) {
            this.controller.hidePopup();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.controller != null) {
            this.controller.hidePopup();
        }
        super.setEnabled(bl);
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SourceTextField.this.showValidationMessage(SourceTextField.this.getValidationMessage());
                }
            };
            this.timer = new Timer(500, actionListener);
            this.timer.setRepeats(false);
        }
        return this.timer;
    }

    private String getValidationMessage() {
        this.currentlyValid = false;
        this.getTimer().stop();
        String string = this.getText();
        String string2 = this.sourceValidator.validateSource(string);
        if (string2 == null) {
            this.currentlyValid = true;
        }
        return string2;
    }
}

