/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.parser;

import oracle.xquery.parser.Node;
import oracle.xquery.parser.XPath;
import oracle.xquery.parser.XPathTreeConstants;
import oracle.xquery.parser.XQXGen;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected XPath parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(XPath xPath, int n) {
        this(n);
        this.parser = xPath;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public String toString() {
        return XPathTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + "  ");
            }
        }
    }

    @Override
    public void dumpSAX(XQXGen xQXGen) {
        this.dumpSAXChildren(xQXGen);
    }

    public void dumpSAXChildren(XQXGen xQXGen) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ((SimpleNode)this.children[i]).dumpSAX(xQXGen);
            }
        }
    }
}

