/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.util.Comparator;
import java.util.Iterator;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DocOrderComparator
implements Comparator {
    private static DocumentNavigator docNav = XMLUtils.getDocumentNavigator();

    public int compare(Object o1, Object o2) {
        try {
            return DocOrderComparator.compareNodes((Node)o1, (Node)o2);
        }
        catch (XPathException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof DocOrderComparator;
    }

    private static boolean isSameNode(Node n1, Node n2) {
        if (n1 == null) {
            return n2 == null;
        }
        if (n1.getNodeType() == 13) {
            return n1.equals(n2);
        }
        return n1 == n2;
    }

    public static int compareNodes(Node n1, Node n2) throws XPathException {
        Node n2a;
        Document doc2;
        if (DocOrderComparator.isSameNode(n1, n2)) {
            return 0;
        }
        Document doc1 = XMLUtils.getOwnerDocument(n1);
        if (doc1 != (doc2 = XMLUtils.getOwnerDocument(n2))) {
            throw new XPathException("Cannot compare nodes in different documents");
        }
        if (n1 == doc1) {
            return -1;
        }
        if (n2 == doc2) {
            return 1;
        }
        short t1 = n1.getNodeType();
        short t2 = n2.getNodeType();
        Node p1 = DocOrderComparator.parentOf(n1);
        if (p1 == null) {
            throw new XPathException("Could not get parent node for " + XMLUtils.toStringNode(n1));
        }
        Node p2 = DocOrderComparator.parentOf(n2);
        if (p2 == null) {
            throw new XPathException("Could not get parent node for " + XMLUtils.toStringNode(n2));
        }
        if (n1.getNodeType() == 2) {
            n1 = DocOrderComparator.attrToNS((Attr)n1, p1);
            t1 = n1.getNodeType();
        }
        if (n2.getNodeType() == 2) {
            n2 = DocOrderComparator.attrToNS((Attr)n2, p2);
            t2 = n2.getNodeType();
        }
        if (p1 == p2) {
            if (t1 == 13) {
                return t2 == 13 ? DocOrderComparator.compareNamespaces(n1, n2) : -1;
            }
            if (t2 == 13) {
                return 1;
            }
            if (t1 == 2) {
                return t2 == 2 ? DocOrderComparator.compareAttrs(n1, n2) : -1;
            }
            if (t2 == 2) {
                return 1;
            }
            return DocOrderComparator.compareSiblings(p1, n1, n2);
        }
        if (n1 == p2) {
            return -1;
        }
        if (n2 == p1) {
            return 1;
        }
        Node n1a = t1 == 2 || t1 == 13 ? p1 : n1;
        Node node = n2a = t2 == 2 || t2 == 13 ? p2 : n2;
        if (DocOrderComparator.isAncestorOf(n1a, n2a)) {
            return 1;
        }
        if (DocOrderComparator.isAncestorOf(n2a, n1a)) {
            return -1;
        }
        if (DocOrderComparator.isPrecedingTo(n1a, n2a)) {
            return 1;
        }
        return -1;
    }

    private static int compareNamespaces(Node n1, Node n2) {
        String ns1 = n1.getNodeName() == null ? "" : n1.getNodeName();
        String ns2 = n2.getNodeName() == null ? "" : n2.getNodeName();
        return ns1.compareTo(ns2);
    }

    private static int compareAttrs(Node n1, Node n2) {
        int result;
        String ns2;
        Attr a1 = (Attr)n1;
        Attr a2 = (Attr)n2;
        String ns1 = XMLUtils.getNamespaceURI(a1);
        if (ns1 == null) {
            ns1 = "";
        }
        if ((ns2 = XMLUtils.getNamespaceURI(a2)) == null) {
            ns2 = "";
        }
        if ((result = ns1.compareTo(ns2)) == 0) {
            String loc1 = QName.getLocalPart(a1.getName());
            String loc2 = QName.getLocalPart(a2.getName());
            result = loc1.compareTo(loc2);
        }
        return result;
    }

    private static int compareSiblings(Node p, Node n1, Node n2) throws XPathException {
        Iterator childAxis = docNav.getChildAxisIterator((Object)p);
        while (childAxis.hasNext()) {
            Node child = (Node)childAxis.next();
            if (DocOrderComparator.isSameNode(n1, child)) {
                return -1;
            }
            if (!DocOrderComparator.isSameNode(n2, child)) continue;
            return 1;
        }
        throw new XPathException("Could not find order of sibling nodes");
    }

    private static boolean isAncestorOf(Node n1, Node n2) throws XPathException {
        try {
            Iterator ancestorAxis = docNav.getAncestorAxisIterator((Object)n1);
            while (ancestorAxis.hasNext()) {
                Node ancestor = (Node)ancestorAxis.next();
                if (!DocOrderComparator.isSameNode(ancestor, n2)) continue;
                return true;
            }
        }
        catch (UnsupportedAxisException ex) {
            throw new XPathException(ex);
        }
        return false;
    }

    private static boolean isPrecedingTo(Node n1, Node n2) throws XPathException {
        try {
            Iterator ancestorAxis = docNav.getAncestorAxisIterator((Object)n1);
            Iterator precedingAxis = docNav.getPrecedingAxisIterator((Object)n1);
            while (precedingAxis.hasNext()) {
                Node preceding = (Node)precedingAxis.next();
                if (!DocOrderComparator.isSameNode(preceding, n2)) continue;
                return true;
            }
        }
        catch (UnsupportedAxisException ex) {
            throw new XPathException(ex);
        }
        return false;
    }

    private static Node parentOf(Node node) {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    private static Node attrToNS(Attr attr, Node parent) {
        String attrName = attr.getName();
        if (attrName.startsWith("xmlns")) {
            String nsPrefix = attrName.equals("xmlns") ? "" : QName.getLocalPart(attrName);
            return new NamespaceNode(parent, nsPrefix, attr.getValue());
        }
        return attr;
    }
}

