/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.meter.BoundedRangeModel;
import oracle.ewt.painter.AbstractWrappingPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.slider.Slider;
import oracle.ewt.slider.SliderInputHandler;
import oracle.ewt.util.InputEventUtils;

public class BasicSliderTrackerPainter
extends AbstractWrappingPainter
implements SliderInputHandler {
    private static final int _TRACK_SIZE = 100;
    private Slider _armedSlider;
    private int _xOffset;
    private int _yOffset;
    private int _width;
    private int _height;

    public BasicSliderTrackerPainter(Painter painter) {
        super(painter);
    }

    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        Dimension dimension = super.getSize(paintContext, n, n2);
        dimension.width = n;
        return dimension;
    }

    public Dimension getPreferredSize(PaintContext paintContext) {
        Dimension dimension = super.getPreferredSize(paintContext);
        dimension.width = 100;
        return dimension;
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        Dimension dimension = super.getMinimumSize(paintContext);
        dimension.width = 100;
        return dimension;
    }

    public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        if (n3 >= 0 && n4 >= 0 && n3 < n && n4 < n2) {
            int n5 = this._getSliderPosition(paintContext, n);
            if (n3 > n5) {
                Painter painter2 = this.getWrappedPainter(paintContext);
                Dimension dimension = painter2.getPreferredSize(paintContext);
                if (n3 < n5 + dimension.width && painter != this) {
                    return painter2;
                }
            }
            return this;
        }
        return null;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this._xOffset = n;
        this._yOffset = n2;
        this._width = n3;
        this._height = n4;
        Painter painter = this.getWrappedPainter(paintContext);
        Dimension dimension = painter.getPreferredSize(paintContext);
        int n5 = this._getSliderPosition(paintContext, n3);
        super.paint(paintContext, graphics, n + n5, n2, dimension.width, dimension.height);
    }

    public boolean isTransparent(PaintContext paintContext) {
        return true;
    }

    public boolean isArmed(Slider slider) {
        return this._armedSlider == slider;
    }

    public void processMouseEvent(MouseEvent mouseEvent, Slider slider) {
        Object object;
        Object object2;
        boolean bl = false;
        if (InputEventUtils.isLeftMouseButton(mouseEvent)) {
            int n;
            object2 = slider.getPaintContext();
            object = this.getWrappedPainter((PaintContext)object2);
            int n2 = mouseEvent.getID();
            int n3 = mouseEvent.getX() - this._xOffset;
            if (n2 == 501) {
                Painter painter = this.getPainterAt((PaintContext)object2, this._width, this._height, n3, mouseEvent.getY() - this._yOffset, (Painter)object);
                bl = painter == object;
            } else if (n2 == 500 && n3 >= 0 && n3 < this._width && (n = mouseEvent.getY() - this._yOffset) >= 0 && n < this._height) {
                int n4 = this._getSliderPosition((PaintContext)object2, this._width);
                if (n3 < n4) {
                    this._incrementValue(slider, -1);
                } else {
                    int n5 = object.getPreferredSize((PaintContext)object2).width;
                    if (n3 > n4 + n5) {
                        this._incrementValue(slider, 1);
                    }
                }
            }
        }
        Object object3 = object2 = bl ? slider : null;
        if (this._armedSlider != object2) {
            object = this._armedSlider;
            this._armedSlider = object2;
            if (object != null) {
                ((Component)object).repaint();
            }
            if (object2 != null) {
                ((Component)object2).requestFocus();
                ((Component)object2).repaint();
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent, Slider slider) {
        PaintContext paintContext;
        if (mouseEvent.getID() == 506 && ((paintContext = slider.getPaintContext()).getPaintState() & 2) != 0) {
            this._setSliderValue(paintContext, mouseEvent.getX() - this._xOffset);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent, Slider slider) {
        if (keyEvent.getID() == 401) {
            BoundedRangeModel boundedRangeModel = slider.getModel();
            int n = boundedRangeModel.getValue();
            switch (keyEvent.getKeyCode()) {
                case 38: 
                case 39: {
                    this._incrementValue(slider, 1);
                    break;
                }
                case 37: 
                case 40: {
                    this._incrementValue(slider, -1);
                }
            }
        }
    }

    private void _setSliderValue(PaintContext paintContext, int n) {
        Object object = paintContext.getPaintData("Model");
        BoundedRangeModel boundedRangeModel = (BoundedRangeModel)object;
        int n2 = boundedRangeModel.getMinimum();
        int n3 = boundedRangeModel.getMaximum() - n2;
        Painter painter = this.getWrappedPainter(paintContext);
        int n4 = painter.getPreferredSize((PaintContext)paintContext).width;
        boundedRangeModel.setValue(n2 + (int)((double)(n -= n4 / 2) / (double)(this._width - n4) * (double)n3 + 0.5));
    }

    private int _getSliderPosition(PaintContext paintContext, int n) {
        Object object = paintContext.getPaintData("Model");
        BoundedRangeModel boundedRangeModel = (BoundedRangeModel)object;
        int n2 = boundedRangeModel.getMinimum();
        int n3 = boundedRangeModel.getMaximum() - n2;
        int n4 = boundedRangeModel.getValue() - n2;
        Painter painter = this.getWrappedPainter(paintContext);
        int n5 = painter.getPreferredSize((PaintContext)paintContext).width;
        return (int)((double)n4 / (double)n3 * (double)(n - n5));
    }

    private void _incrementValue(Slider slider, int n) {
        if (n != 0) {
            BoundedRangeModel boundedRangeModel = slider.getModel();
            boundedRangeModel.setValue(boundedRangeModel.getValue() + n);
        }
    }
}

