/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import java.util.Locale;
import oracle.ewt.ColorScheme;
import oracle.ewt.HashTableDefaults;
import oracle.ewt.LookAndFeel;
import oracle.ewt.MultiUIDefaults;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.graphics.NullImageFilter;
import oracle.ewt.graphics.SynthesizingImageSet;
import oracle.ewt.laf.basic.BasicLookAndFeel;
import oracle.ewt.laf.basic.DisabledBGPainter;
import oracle.ewt.laf.basic.PerComponentUIInstantiator;
import oracle.ewt.laf.basic.SingletonUIInstantiator;
import oracle.ewt.laf.basic.StringInstantiator;
import oracle.ewt.laf.oracle.OracleBrowserColorScheme;
import oracle.ewt.laf.oracle.OracleColorScheme;
import oracle.ewt.laf.oracle.OracleCustomizableColorScheme;
import oracle.ewt.laf.oracle.OracleGroupBoxPainter;
import oracle.ewt.laf.oracle.OracleInsetBorderPainter;
import oracle.ewt.laf.oracle.OracleRoundedPainter;
import oracle.ewt.laf.oracle.OracleStatusBarPainter;
import oracle.ewt.laf.oracle.OracleSwanColorScheme;
import oracle.ewt.laf.oracle.OracleToolBarPainter;
import oracle.ewt.laf.oracle.OracleUIUtils;
import oracle.ewt.laf.oracle.ScrollBoxBorderPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FGBGColorChange;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.StatusBarUI;
import oracle.ewt.plaf.TextUI;
import oracle.ewt.plaf.ToolBarUI;

public class OracleLookAndFeel
extends BasicLookAndFeel
implements Serializable {
    private static final String _PACKAGE_NAME = "oracle.ewt.laf.oracle.";
    private static final String _UIUTILS_NAME = "oracle.ewt.laf.oracle.OracleUIUtils";
    private static final String _DEF_IMAGE_INSTANT = "oracle.ewt.laf.oracle.OracleUIUtils#imageInst|";
    private static final String _DEF_CIMAGE_INSTANT = "oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|";
    private static final String _DEF_IMAGEFILTER_INSTANT = "oracle.ewt.laf.oracle.OracleUIUtils#imageFilterInst|";
    private static final int _REALLY_DARK_LUMINANCE = 51;
    private static final int _DARK_LUMINANCE = 139;
    private static final int _LIGHT_LUMINANCE = 204;
    private static final int _DEFAULT_SCHEME_INDEX = 6;
    private static final int _CUSTOMIZABLE_SCHEME_INDEX = 10;
    static final boolean __USE_HIGH_COLOR;
    private static UIDefaults _sCommonDefaults;
    private static final OracleColorScheme[] _sAvailableSchemes;
    private static OracleColorScheme _sDefaultScheme;
    private static final UIDefaults[] _COMMON_SCHEME_DEFAULTS;
    private static final UIDefaults[] _LUM_SCHEME_DEFAULTS;
    private static final MultiUIDefaults[] _UI_DEFAULTS;

    public String getName() {
        return "Oracle";
    }

    public String getDisplayName(Locale locale) {
        return "Oracle Look and Feel";
    }

    public String getDescription(Locale locale) {
        return "The Oracle Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public BorderPainter createGroupBoxPainter(Painter painter, Painter painter2) {
        return new OracleGroupBoxPainter(painter, painter2);
    }

    public boolean isGroupBoxPainter(BorderPainter borderPainter) {
        return borderPainter instanceof OracleGroupBoxPainter;
    }

    public String getGroupBoxTitle(BorderPainter borderPainter) {
        if (!this.isGroupBoxPainter(borderPainter)) {
            return null;
        }
        OracleGroupBoxPainter oracleGroupBoxPainter = (OracleGroupBoxPainter)borderPainter;
        Painter painter = oracleGroupBoxPainter.getLabelPainter();
        return this.getGroupBoxTitleFromLabelPainter(painter);
    }

    static boolean __isDarkDefaults(PaintContext paintContext) {
        int n;
        Color color;
        return paintContext != null && (color = paintContext.getSurroundingColor()) != null && (n = ColorUtils.getApproximateLuminance(color)) <= 139 && n > 51;
    }

    public UIDefaults getDefaults(PaintContext paintContext) {
        int n = OracleLookAndFeel._getSchemeIndex(paintContext);
        if (OracleLookAndFeel.__isDarkDefaults(paintContext)) {
            ++n;
        }
        return this._getIndexedDefaults(n);
    }

    static ImageFilter createColorizingFilter(ColorScheme colorScheme) {
        return colorScheme == null ? _sDefaultScheme.createColorizingFilter() : colorScheme.createColorizingFilter();
    }

    public ColorScheme getDefaultColorScheme() {
        return _sDefaultScheme;
    }

    public void setDefaultColorScheme(ColorScheme colorScheme) {
        if (!(colorScheme instanceof OracleColorScheme)) {
            colorScheme = this.getColorScheme(colorScheme);
        }
        _sDefaultScheme = (OracleColorScheme)colorScheme;
    }

    protected boolean isCompatibleColorScheme(ColorScheme colorScheme) {
        return colorScheme instanceof OracleColorScheme;
    }

    protected ColorScheme[] getReadOnlyColorSchemes() {
        return _sAvailableSchemes;
    }

    UIDefaults __getLightDefaults(LWComponent lWComponent) {
        return this._getIndexedDefaults(OracleLookAndFeel._getSchemeIndex(lWComponent));
    }

    UIDefaults __getDarkDefaults(LWComponent lWComponent) {
        return this._getIndexedDefaults(OracleLookAndFeel._getSchemeIndex(lWComponent) + 1);
    }

    private static int _getSchemeIndex(LWComponent lWComponent) {
        return OracleLookAndFeel._getSchemeIndex(lWComponent.getColorScheme());
    }

    private static int _getSchemeIndex(PaintContext paintContext) {
        ColorScheme colorScheme = null;
        if (paintContext != null) {
            colorScheme = paintContext.getColorScheme();
        }
        return OracleLookAndFeel._getSchemeIndex(colorScheme);
    }

    private static int _getSchemeIndex(ColorScheme colorScheme) {
        if (colorScheme == null) {
            colorScheme = _sDefaultScheme;
        }
        return ((OracleColorScheme)colorScheme).getSchemeIndex() * 2;
    }

    private void _initColorizedCommonDefaults(UIDefaults uIDefaults, UIDefaults uIDefaults2) {
        Color color = uIDefaults.getColor(LookAndFeel.CONTROL);
        Color color2 = uIDefaults.getColor(LookAndFeel.DESKTOP);
        Color color3 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        Color color4 = uIDefaults.getColor(LookAndFeel.LIGHT_INTENSITY);
        Color color5 = uIDefaults.getColor(LookAndFeel.SCROLLBAR);
        Color color6 = uIDefaults.getColor(LookAndFeel.TEXT);
        Color color7 = uIDefaults.getColor(LookAndFeel.TOOL_TIP);
        Color color8 = uIDefaults.getColor(LookAndFeel.WINDOW);
        Color color9 = uIDefaults.getColor(LookAndFeel.MENU);
        Color color10 = uIDefaults.getColor(OracleColorScheme.HEADER);
        Color color11 = uIDefaults.getColor(OracleColorScheme.GRID);
        uIDefaults2.put("Button.background", color);
        uIDefaults2.put("ChoiceButton.background", color);
        uIDefaults2.put("CalendarTable.background", color4);
        uIDefaults2.put("Choice.background", color);
        uIDefaults2.put("DateEditor.background", color6);
        uIDefaults2.put("Desktop.background", color2);
        uIDefaults2.put("Drawer.background", color);
        uIDefaults2.put("EwtButton.background", color);
        uIDefaults2.put("FontPane.background", color);
        uIDefaults2.put("Grid.background", color11);
        uIDefaults2.put("List.background", color6);
        uIDefaults2.put("MDIRootPane.background", color2);
        uIDefaults2.put("PasswordField.background", color6);
        uIDefaults2.put("PivotGrid.background", color);
        uIDefaults2.put("PivotHeader.background", color);
        uIDefaults2.put("PivotTable.background", color);
        uIDefaults2.put("PopupMenu.background", color9);
        uIDefaults2.put("ProgressBar.background", color6);
        uIDefaults2.put("Ruler.background", color4);
        uIDefaults2.put("Spinner.background", color6);
        uIDefaults2.put("ScrollBar.background", color5);
        uIDefaults2.put("TableHeader.background", color10);
        uIDefaults2.put("TableScrollPane.background", color3);
        uIDefaults2.put("Table.background", color11);
        uIDefaults2.put("TextArea.background", color6);
        uIDefaults2.put("TextField.background", color6);
        uIDefaults2.put("EWTToggleButton.background", color);
        uIDefaults2.put("ToolBar.background", color);
        uIDefaults2.put("ToolTip.background", color7);
        uIDefaults2.put("Tree.background", color6);
        uIDefaults2.put("Window.background", color8);
        Color color12 = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT);
        Color color13 = uIDefaults.getColor(LookAndFeel.INFO_TEXT);
        Color color14 = uIDefaults.getColor(LookAndFeel.TEXT_TEXT);
        uIDefaults2.put("BusyBar.foreground", color12);
        uIDefaults2.put("Button.foreground", color14);
        uIDefaults2.put("Choice.foreground", color14);
        uIDefaults2.put("ComboBox.foreground", color14);
        uIDefaults2.put("DateEditor.foreground", color14);
        uIDefaults2.put("Drawer.foreground", color14);
        uIDefaults2.put("Grid.foreground", color14);
        uIDefaults2.put("List.foreground", color14);
        uIDefaults2.put("PasswordField.foreground", color14);
        uIDefaults2.put("ProgressBar.foreground", color14);
        uIDefaults2.put("Ruler.foreground", color3);
        uIDefaults2.put("Spinner.foreground", color14);
        uIDefaults2.put("TabBar.foreground", color14);
        uIDefaults2.put("Table.foreground", color14);
        uIDefaults2.put("TextArea.foreground", color14);
        uIDefaults2.put("TextField.foreground", color14);
        uIDefaults2.put("EWTToggleButton.foreground", color14);
        uIDefaults2.put("ToolTip.foreground", color13);
        uIDefaults2.put("Tree.foreground", color14);
        Color color15 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        Color color16 = uIDefaults.getColor(LookAndFeel.DARK_INTENSITY);
        Color color17 = Color.white;
        Color color18 = Color.black;
        uIDefaults2.put("Button.lightBorder", color17);
        uIDefaults2.put("Button.darkBorder", color15);
        uIDefaults2.put("Button.defaultButtonBorder", color18);
        uIDefaults2.put("Ruler.numbers", color16);
        uIDefaults2.put("Slider.unarmedTrack", color4);
        uIDefaults2.put("TabBar.itemBackground", color3);
        uIDefaults2.put("TabBar.inactiveItemBackground", color3);
        uIDefaults2.put("TabBar.selectedItemBackground", color);
        uIDefaults2.put("TabBar.inactiveSelectedItemBackground", color);
        uIDefaults2.put("TabBar.selectedItemForeground", color18);
        uIDefaults2.put("TabBar.unselectedBorderColor", color3);
        uIDefaults2.put("TabPanel.itemBackground", color);
        uIDefaults2.put("TabPanel.normal", color3);
        uIDefaults2.put("TabPanel.lightBorderColor", color17);
        uIDefaults2.put("TabPanel.cornerColor", color17);
        uIDefaults2.put("TabPanel.darkBorderColor", color15);
        uIDefaults2.put("PopupMenu.darkBorder", color18);
        uIDefaults2.put("Window.lightGrippy", color3);
        uIDefaults2.put("Window.darkGrippy", color18);
        uIDefaults2.put("Window.darkBorder", color18);
        uIDefaults2.put("MDIRootPane.topBorder", color18);
        Object[] objectArray = new Object[]{"ArrowBoxUI", new SingletonUIInstantiator(), "BusyBarUI", new SingletonUIInstantiator(), "ButtonUI", new SingletonUIInstantiator(), "CalendarTableUI", new SingletonUIInstantiator(), "CheckBoxUI", new SingletonUIInstantiator(), "ChoiceUI", new SingletonUIInstantiator(), "ComboBoxUI", new SingletonUIInstantiator(), "ComponentUI", new SingletonUIInstantiator(), "DateEditorUI", new SingletonUIInstantiator(), "DrawerUI", new SingletonUIInstantiator(), "FontPaneUI", new SingletonUIInstantiator(), "EwtButtonUI", new SingletonUIInstantiator(), "GridUI", new SingletonUIInstantiator(), "LabelUI", new SingletonUIInstantiator(), "ListUI", new SingletonUIInstantiator(), "MenuSeparatorUI", new SingletonUIInstantiator(), "MeterUI", new SingletonUIInstantiator(), "MDIRootPaneUI", new SingletonUIInstantiator(), "PasswordFieldUI", new SingletonUIInstantiator(), "RadioButtonUI", new SingletonUIInstantiator(), "EWTToggleButtonUI", new SingletonUIInstantiator(), "PivotGridUI", new SingletonUIInstantiator(), "PivotHeaderUI", new SingletonUIInstantiator(), "PivotTableUI", new SingletonUIInstantiator(), "ProgressBarUI", new SingletonUIInstantiator(), "RulerUI", new SingletonUIInstantiator(), "ScrollBarUI", new SingletonUIInstantiator(), "ScrollPaneUI", new SingletonUIInstantiator(), "ShuttleUI", new SingletonUIInstantiator(), "SplitPaneUI", new SingletonUIInstantiator(), "SliderUI", new SingletonUIInstantiator(), "SpinButtonUI", new SingletonUIInstantiator(), "SpinnerUI", new SingletonUIInstantiator(), "StatusBarUI", new SingletonUIInstantiator(), "TabBarUI", new SingletonUIInstantiator(), "TabbedPaneUI", new SingletonUIInstantiator(), "TableUI", new SingletonUIInstantiator(), "TableHeaderUI", new SingletonUIInstantiator(), "TableScrollPaneUI", new SingletonUIInstantiator(), "TextAreaUI", new SingletonUIInstantiator(), "TextFieldUI", new SingletonUIInstantiator(), "TitleBarUI", new SingletonUIInstantiator(), "ToolBarUI", new SingletonUIInstantiator(), "ToolTipUI", new SingletonUIInstantiator(), "TreeUI", new SingletonUIInstantiator(), "WizardUI", new SingletonUIInstantiator()};
        uIDefaults2.putDefaults(objectArray);
    }

    private void _initColorizedComponentDefaults(UIDefaults uIDefaults, UIDefaults uIDefaults2) {
        Color color = uIDefaults.getColor(LookAndFeel.CONTROL_TEXT);
        Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        Color color3 = uIDefaults.getColor(OracleColorScheme.CONTROL_LT_HIGHLIGHT_VERY_DARK);
        Color color4 = uIDefaults.getColor(OracleColorScheme.HEADER_TEXT);
        Color color5 = uIDefaults.getColor(OracleColorScheme.GRID_TEXT);
        uIDefaults2.put("CheckBox.foreground", color);
        uIDefaults2.put("EwtButton.foreground", color);
        uIDefaults2.put("FontPane.foreground", color);
        uIDefaults2.put("Label.foreground", color);
        uIDefaults2.put("RadioButton.foreground", color);
        uIDefaults2.put("ScrollBar.foreground", color2);
        uIDefaults2.put("StatusBar.foreground", color);
        uIDefaults2.put("TableHeader.foreground", color4);
        uIDefaults2.put("Grid.foreground", color5);
        uIDefaults2.put("ToolBar.foreground", color);
        uIDefaults2.put("MDIRootPane.bottomBorder", color3);
    }

    private static void _initShadowDeferredDefaults(UIDefaults uIDefaults, OracleColorScheme oracleColorScheme, boolean bl) {
        String string;
        String string2;
        String string3 = oracleColorScheme.getName();
        if (bl) {
            string2 = "dkCheckboxStrip.gif%";
            string = "dkRadioButtonStrip.gif%";
        } else {
            string2 = "checkboxStrip.gif%";
            string = "radioButtonStrip.gif%";
        }
        Object[] objectArray = new Object[]{"CheckBoxPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleCheckBoxUI", false), "CheckBoxComponentPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleCheckBoxUI", false), "RadioButtonPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleRadioButtonUI", false), "RadioButtonComponentPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleRadioButtonUI", false), "checkboxSet", new StringInstantiator("oracle.ewt.laf.oracle.OracleCheckBoxUI", false), "radioButtonSet", new StringInstantiator("oracle.ewt.laf.oracle.OracleRadioButtonUI", false), "checkboxStrip", new StringInstantiator(_DEF_CIMAGE_INSTANT + string2 + string3, false), "radioButtonStrip", new StringInstantiator(_DEF_CIMAGE_INSTANT + string + string3, false)};
        uIDefaults.putDefaults(objectArray);
    }

    private static void _initColorizedDeferredDefaults(UIDefaults uIDefaults, OracleColorScheme oracleColorScheme) {
        String string = OracleLookAndFeel.class.getName() + "|";
        String string2 = oracleColorScheme.getName();
        Object[] objectArray = new Object[]{"CTChoice.arrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|ctChoice.gif%" + string2, false), "Choice.arrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|choice.gif%" + string2, false), "Slider.pointerStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|sliderArrowStrip.gif%" + string2, false), "LeftCalendarPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleCalendarTableUI", false), "RightCalendarPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleCalendarTableUI", false), "LeftCalendarPainterSet", new StringInstantiator("oracle.ewt.laf.oracle.OracleCalendarTableUI", false), "RightCalendarPainterSet", new StringInstantiator("oracle.ewt.laf.oracle.OracleCalendarTableUI", false), "LeftCalendarStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|leftCalendarStrip.gif%" + string2, false), "RightCalendarStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|rightCalendarStrip.gif%" + string2, false), "UpScrollPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleScrollBarUI", false), "DownScrollPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleScrollBarUI", false), "LeftScrollPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleScrollBarUI", false), "RightScrollPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleScrollBarUI", false), "UpScrollSet", new StringInstantiator("oracle.ewt.laf.oracle.OracleScrollBarUI", false), "DownScrollSet", new StringInstantiator("oracle.ewt.laf.oracle.OracleScrollBarUI", false), "LeftScrollSet", new StringInstantiator("oracle.ewt.laf.oracle.OracleScrollBarUI", false), "RightScrollSet", new StringInstantiator("oracle.ewt.laf.oracle.OracleScrollBarUI", false), "UpScrollStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|upScrollStrip.gif%" + string2, false), "DownScrollStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|downScrollStrip.gif%" + string2, false), "LeftScrollStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|leftScrollStrip.gif%" + string2, false), "RightScrollStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|rightScrollStrip.gif%" + string2, false), "SpinButton.rightArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|spinRightArrow.gif%" + string2, false), "SpinButton.leftArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|spinLeftArrow.gif%" + string2, false), "SpinButton.downArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|spinDownArrow.gif%" + string2, false), "SpinButton.upArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|spinUpArrow.gif%" + string2, false), "Grid.checkPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleGridUI", false), "Grid.radioPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleGridUI", false), "Shuttle.rightArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|rightArrow.gif%" + string2, false), "Shuttle.rightAllArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|rightAllArrow.gif%" + string2, false), "Shuttle.leftArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|leftArrow.gif%" + string2, false), "Shuttle.leftAllArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|leftAllArrow.gif%" + string2, false), "Shuttle.downArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|downArrow.gif%" + string2, false), "Shuttle.downAllArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|downAllArrow.gif%" + string2, false), "Shuttle.upArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|upArrow.gif%" + string2, false), "Shuttle.upAllArrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|upAllArrow.gif%" + string2, false), "Shuttle.reorderUpRight", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|reorderUpRight.gif%" + string2, false), "Shuttle.reorderDownRight", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|reorderDownRight.gif%" + string2, false), "Shuttle.reorderUpLeft", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|reorderUpLeft.gif%" + string2, false), "Shuttle.reorderDownLeft", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|reorderDownLeft.gif%" + string2, false), "TabBar.scrollLeft", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|tableft.gif%" + string2, false), "TabBar.scrollRight", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|tabright.gif%" + string2, false), "TabBar.scrollBoth", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|tabboth.gif%" + string2, false), "TabBar.visibleStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|tabvisstrip.gif%" + string2, false), "TabBar.visible", new StringInstantiator("oracle.ewt.laf.oracle.OracleTabBarUI", false), "Tree.openImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|expand.gif%" + string2, false), "Tree.closedImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|collapse.gif%" + string2, false), "Tree.RTLopenImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|rtlExpand.gif%" + string2, false), "Tree.multiItemDrag", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#cImageInst|multiItemDrag.gif%" + string2, false), "ExpandedNodePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTreeUI", false), "CollapsedNodePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTreeUI", false), "RTLCollapsedNodePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTreeUI", false), "Window.closeStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|closeStrip.gif", false), "Window.maximizeStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|maximizeStrip.gif", false), "Window.minimizeStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|minimizeStrip.gif", false), "Window.restoreStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|restoreStrip.gif", false), "Window.pCloseStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|pCloseStrip.gif", false), "Window.pMaximizeStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|pMaximizeStrip.gif", false), "Window.pMinimizeStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|pMinimizeStrip.gif", false), "Window.pRestoreStrip", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|pRestoreStrip.gif", false), "BusyBar.busyLeftImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|busyLeft.gif", false), "BusyBar.busyRightImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|busyRight.gif", false), "PivotHeader.drillImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|drillTriangle.gif", false), "PivotHeader.drilledImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|drilledTriangle.gif", false), "Window.closePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTitleBarUI", false), "Window.maximizePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTitleBarUI", false), "Window.minimizePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTitleBarUI", false), "Window.restorePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTitleBarUI", false), "Window.pClosePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTitleBarUI", false), "Window.pMaximizePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTitleBarUI", false), "Window.pMinimizePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTitleBarUI", false), "Window.pRestorePainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTitleBarUI", false)};
        uIDefaults.putDefaults(objectArray);
    }

    private static void _initCommonDeferredDefaults(UIDefaults uIDefaults) {
        uIDefaults.put(LookAndFeel.BACKGROUND_PAINTER, OracleUIUtils.getBackgroundPainter());
        uIDefaults.put(LookAndFeel.IMAGE_PAINTER, OracleUIUtils.getImagePainter());
        uIDefaults.put(LookAndFeel.IMAGE_SET_PAINTER, OracleUIUtils.getImageSetPainter());
        Object[] objectArray = new Object[]{"DefaultCellPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleGridUI", false), "DefaultHeaderPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleTableHeaderUI", false), "Alert.errorImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|stop.gif", false), "Alert.warningImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|caution.gif", false), "Alert.informationImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|note.gif", false), "Alert.questionImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|question.gif", false), "ColorChoice.arrow", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|colorChoice.gif", false), "Grid.checkImage", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|check.gif", false), LookAndFeel.DISABLING_FILTER, new StringInstantiator(_DEF_IMAGEFILTER_INSTANT, true), "HorizInsetSeparator", new StringInstantiator("oracle.ewt.laf.oracle.OracleSeparatorPainter", false), "HorizOutsetSeparator", new StringInstantiator("oracle.ewt.laf.oracle.OracleSeparatorPainter", false), "VertInsetSeparator", new StringInstantiator("oracle.ewt.laf.oracle.OracleSeparatorPainter", false), "VertOutsetSeparator", new StringInstantiator("oracle.ewt.laf.oracle.OracleSeparatorPainter", false), "FileChooser.folder", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|folder.gif", false), "MDIRootPane.Logo", new StringInstantiator("oracle.ewt.laf.oracle.OracleUIUtils#imageInst|oracleLogo.gif", false), "MDIRootPane.LogoPainter", new StringInstantiator("oracle.ewt.laf.oracle.OracleMDIRootPaneUI", false)};
        uIDefaults.putDefaults(objectArray);
    }

    private static UIDefaults _getCommonDefaults() {
        if (_sCommonDefaults == null) {
            HashTableDefaults hashTableDefaults = new HashTableDefaults(50);
            OracleLookAndFeel._initCommonFixedDefaults(hashTableDefaults);
            OracleLookAndFeel._initCommonDeferredDefaults(hashTableDefaults);
            _sCommonDefaults = hashTableDefaults;
        }
        return _sCommonDefaults;
    }

    private static void _initCommonFixedDefaults(UIDefaults uIDefaults) {
        BasicLookAndFeel.initCommonFixedDefaults(uIDefaults);
        Object[] objectArray = new Object[]{"AlertUI", new PerComponentUIInstantiator(), "CheckboxMenuItemUI", new PerComponentUIInstantiator(), "DesktopUI", new PerComponentUIInstantiator(), "MenuBarUI", new PerComponentUIInstantiator(), "MenuUI", new PerComponentUIInstantiator(), "MenuItemUI", new PerComponentUIInstantiator(), "RadioButtonMenuItemUI", new PerComponentUIInstantiator(), "PopupMenuUI", new PerComponentUIInstantiator(), "WindowUI", new PerComponentUIInstantiator()};
        uIDefaults.putDefaults(objectArray);
        Object[] objectArray2 = new Object[]{LookAndFeel.TOOL_TIP, LookAndFeel.SELECTED_FOCUS, LookAndFeel.WINDOW_BORDER, LookAndFeel.PINSTRIPE1, LookAndFeel.PINSTRIPE2};
        int[] nArray = new int[]{0xFFFFCC, 0xFFFFFF, 0, __USE_HIGH_COLOR ? 16773835 : 0xFFFFCC, __USE_HIGH_COLOR ? 16439688 : 0xFFCC66};
        for (int i = 0; i < objectArray2.length; ++i) {
            uIDefaults.put(objectArray2[i], new Color(nArray[i]));
        }
        Font font = new Font("SansSerif", 0, 9);
        uIDefaults.put("ToolBar.font", font);
        uIDefaults.put("ToolTip.font", new Font("SansSerif", 0, 12));
        uIDefaults.put("TitleBar.font", new Font("Dialog", 1, 12));
        uIDefaults.put("TitleBar.paletteFont", new Font("Dialog", 1, 10));
        uIDefaults.put(StatusBarUI.STATUSBAR_BORDER, new OracleStatusBarPainter());
        uIDefaults.put(StatusBarUI.STATUSBAR_ITEM_BORDER, null);
        BorderPainter borderPainter = OracleUIUtils.getNarrowInsetBorderPainter();
        BorderPainter borderPainter2 = LWComponent.DEFAULT_BORDERPAINTER;
        uIDefaults.put(TextUI.TEXT_FIELD_LOWERED_BORDER, borderPainter);
        uIDefaults.put(TextUI.TEXT_FIELD_PLAIN_BORDER, borderPainter2);
        uIDefaults.put(TextUI.TEXT_FIELD_RAISED_BORDER, borderPainter2);
        OracleInsetBorderPainter oracleInsetBorderPainter = new OracleInsetBorderPainter(new FixedBorderPainter(1, 1, 1, 1), false);
        uIDefaults.put(TextUI.TEXT_AREA_LOWERED_BORDER, oracleInsetBorderPainter);
        uIDefaults.put(TextUI.TEXT_AREA_PLAIN_BORDER, borderPainter2);
        uIDefaults.put(TextUI.TEXT_AREA_RAISED_BORDER, borderPainter2);
        uIDefaults.put(ToolBarUI.TOOLBAR_HORIZONTAL_BORDER, new OracleToolBarPainter(null, false, true));
        uIDefaults.put(ToolBarUI.TOOLBAR_VERTICAL_BORDER, new OracleToolBarPainter(null, false, false));
        ScrollBoxBorderPainter scrollBoxBorderPainter = new ScrollBoxBorderPainter();
        uIDefaults.put("List.border", scrollBoxBorderPainter);
        uIDefaults.put("PasswordField.border", borderPainter);
        uIDefaults.put("ScrollPane.border", scrollBoxBorderPainter);
        uIDefaults.put("TextArea.border", oracleInsetBorderPainter);
        uIDefaults.put("TextField.border", borderPainter);
        BorderPainter borderPainter3 = NullPainter.getPainter();
        Painter painter = OracleUIUtils.getDisabledBackgroundPainter();
        FGBGColorChange fGBGColorChange = new FGBGColorChange(new OracleRoundedPainter(), false);
        DisabledBGPainter disabledBGPainter = new DisabledBGPainter(OracleUIUtils.getFilledRectanglePainter(), TextUI.TEXT_IS_EDITABLE_KEY);
        uIDefaults.put("Choice.fill", painter);
        uIDefaults.put("ComboBox.fill", painter);
        uIDefaults.put("DateEditor.fill", painter);
        uIDefaults.put("Grid.fill", painter);
        uIDefaults.put("List.fill", borderPainter3);
        uIDefaults.put("PasswordField.fill", disabledBGPainter);
        uIDefaults.put("ProgressBar.fill", painter);
        uIDefaults.put("ScrollBar.fill", borderPainter3);
        uIDefaults.put("SpinButton.fill", borderPainter3);
        uIDefaults.put("Spinner.fill", disabledBGPainter);
        uIDefaults.put("SplitPane.fill", borderPainter3);
        uIDefaults.put("TabbedPane.fill", borderPainter3);
        uIDefaults.put("TabBar.fill", borderPainter3);
        uIDefaults.put("TableScrollPane.fill", fGBGColorChange);
        uIDefaults.put("Table.fill", painter);
        uIDefaults.put("TextArea.fill", disabledBGPainter);
        uIDefaults.put("TextField.fill", disabledBGPainter);
        uIDefaults.put("ToolBar.fill", borderPainter3);
        uIDefaults.put("Tree.fill", painter);
        uIDefaults.put(ToolBarUI.BASE_IMAGE_STATE, new Integer(0));
        uIDefaults.put(WINDOW_ACTIVATION_REPAINTING, Boolean.TRUE);
        uIDefaults.put(SynthesizingImageSet.NO_MOUSE_FILTER, NullImageFilter.getImageFilter());
    }

    private UIDefaults _getIndexedDefaults(int n) {
        if (_UI_DEFAULTS[n] == null) {
            int n2 = n / 2;
            OracleColorScheme oracleColorScheme = _sAvailableSchemes[n2];
            UIDefaults uIDefaults = OracleLookAndFeel._getCommonDefaults();
            UIDefaults[] uIDefaultsArray = new UIDefaults[2];
            if (_COMMON_SCHEME_DEFAULTS[n2] == null) {
                HashTableDefaults hashTableDefaults = new HashTableDefaults(30);
                oracleColorScheme.initializeCommonColors(hashTableDefaults);
                OracleLookAndFeel._initColorizedDeferredDefaults(hashTableDefaults, oracleColorScheme);
                OracleLookAndFeel._COMMON_SCHEME_DEFAULTS[n2] = hashTableDefaults;
            }
            boolean bl = false;
            uIDefaultsArray[0] = _COMMON_SCHEME_DEFAULTS[n2];
            if (_LUM_SCHEME_DEFAULTS[n] == null) {
                boolean bl2 = n % 2 == 1;
                int n3 = n2 * 2;
                if (!bl2) {
                    ++n3;
                }
                bl = _LUM_SCHEME_DEFAULTS[n3] == null;
                HashTableDefaults hashTableDefaults = new HashTableDefaults(51);
                OracleLookAndFeel._initShadowDeferredDefaults(hashTableDefaults, oracleColorScheme, bl2);
                if (bl2) {
                    oracleColorScheme.initializeDarkColors(hashTableDefaults);
                } else {
                    oracleColorScheme.initializeLightColors(hashTableDefaults);
                }
                OracleLookAndFeel._LUM_SCHEME_DEFAULTS[n] = hashTableDefaults;
            }
            uIDefaultsArray[1] = _LUM_SCHEME_DEFAULTS[n];
            MultiUIDefaults multiUIDefaults = new MultiUIDefaults(uIDefaultsArray, uIDefaults);
            if (bl) {
                this._initColorizedCommonDefaults(multiUIDefaults, uIDefaultsArray[0]);
                oracleColorScheme.__initCommonDefaults(multiUIDefaults, uIDefaultsArray[0]);
            }
            this._initColorizedComponentDefaults(multiUIDefaults, uIDefaultsArray[1]);
            OracleLookAndFeel._UI_DEFAULTS[n] = multiUIDefaults;
        }
        return _UI_DEFAULTS[n];
    }

    public static OracleColorScheme configureCustomColorScheme(String string, String string2, int[] nArray) {
        return OracleLookAndFeel.configureCustomColorScheme(string, string2, nArray, -1);
    }

    public static OracleColorScheme configureCustomColorScheme(String string, String string2, int[] nArray, int n) {
        OracleCustomizableColorScheme oracleCustomizableColorScheme = (OracleCustomizableColorScheme)_sAvailableSchemes[10];
        oracleCustomizableColorScheme.setName(string);
        oracleCustomizableColorScheme.setDescription(string2);
        oracleCustomizableColorScheme.__setIntRamp(nArray);
        oracleCustomizableColorScheme.setDesktopColor(n);
        return oracleCustomizableColorScheme;
    }

    static {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5;
        int[] nArray6;
        int[] nArray7;
        __USE_HIGH_COLOR = !(Toolkit.getDefaultToolkit().getColorModel() instanceof IndexColorModel);
        OracleColorScheme[] oracleColorSchemeArray = new OracleColorScheme[11];
        if (__USE_HIGH_COLOR) {
            int[] nArray8 = new int[9];
            nArray8[0] = -1;
            nArray8[1] = -858993460;
            nArray8[2] = -1718246217;
            nArray8[3] = 1717532051;
            nArray8[4] = 858339404;
            nArray8[5] = 0;
            nArray8[6] = 255;
            nArray8[7] = 14674679;
            nArray7 = nArray8;
            nArray8[8] = 11849708;
        } else {
            int[] nArray9 = new int[9];
            nArray9[0] = -1;
            nArray9[1] = -858993460;
            nArray9[2] = -1721329204;
            nArray9[3] = 0x66336699;
            nArray9[4] = 0x33000033;
            nArray9[5] = 0;
            nArray9[6] = 255;
            nArray9[7] = 0x99CCFF;
            nArray7 = nArray9;
            nArray9[8] = 0x6699FF;
        }
        oracleColorSchemeArray[0] = new OracleColorScheme("Blue", "Oracle Blue Color Scheme", nArray7, 0);
        if (__USE_HIGH_COLOR) {
            int[] nArray10 = new int[9];
            nArray10[0] = -1;
            nArray10[1] = -858993460;
            nArray10[2] = -1716210791;
            nArray10[3] = 1720552570;
            nArray10[4] = 860634894;
            nArray10[5] = 0;
            nArray10[6] = 255;
            nArray10[7] = 16316383;
            nArray6 = nArray10;
            nArray10[8] = 0xEEEBB2;
        } else {
            int[] nArray11 = new int[9];
            nArray11[0] = -1;
            nArray11[1] = -858993460;
            nArray11[2] = -1714631527;
            nArray11[3] = 0x66999966;
            nArray11[4] = 0x33666600;
            nArray11[5] = 0;
            nArray11[6] = 255;
            nArray11[7] = 0xCCCC99;
            nArray6 = nArray11;
            nArray11[8] = 0xCCCC00;
        }
        oracleColorSchemeArray[1] = new OracleColorScheme("Khaki", "Oracle Khaki Color Scheme", nArray6, 1);
        if (__USE_HIGH_COLOR) {
            int[] nArray12 = new int[9];
            nArray12[0] = -1;
            nArray12[1] = -858993460;
            nArray12[2] = -1717130082;
            nArray12[3] = 1718317666;
            nArray12[4] = 859981372;
            nArray12[5] = 0;
            nArray12[6] = 255;
            nArray12[7] = 15661279;
            nArray5 = nArray12;
            nArray12[8] = 14020274;
        } else {
            int[] nArray13 = new int[9];
            nArray13[0] = -1;
            nArray13[1] = -858993460;
            nArray13[2] = -1717986970;
            nArray13[3] = 0x66666633;
            nArray13[4] = 0x33003300;
            nArray13[5] = 0;
            nArray13[6] = 255;
            nArray13[7] = 0xCCCC99;
            nArray5 = nArray13;
            nArray13[8] = 0x999900;
        }
        oracleColorSchemeArray[2] = new OracleColorScheme("Olive", "Oracle Green Color Scheme", nArray5, 2);
        if (__USE_HIGH_COLOR) {
            int[] nArray14 = new int[9];
            nArray14[0] = -1;
            nArray14[1] = -858993460;
            nArray14[2] = -1716145981;
            nArray14[3] = 1719169422;
            nArray14[4] = 859057482;
            nArray14[5] = 0;
            nArray14[6] = 255;
            nArray14[7] = 15065080;
            nArray4 = nArray14;
            nArray14[8] = 12628718;
        } else {
            int[] nArray15 = new int[9];
            nArray15[0] = -1;
            nArray15[1] = -858993460;
            nArray15[2] = -1717986868;
            nArray15[3] = 0x66666699;
            nArray15[4] = 0x33330033;
            nArray15[5] = 0;
            nArray15[6] = 255;
            nArray15[7] = 0xCCCCFF;
            nArray4 = nArray15;
            nArray15[8] = 0x9999FF;
        }
        oracleColorSchemeArray[3] = new OracleColorScheme("Purple", "Oracle Purple Color Scheme", nArray4, 3);
        if (__USE_HIGH_COLOR) {
            int[] nArray16 = new int[9];
            nArray16[0] = -1;
            nArray16[1] = -858993460;
            nArray16[2] = -1714770265;
            nArray16[3] = 1721598072;
            nArray16[4] = 860629799;
            nArray16[5] = 0;
            nArray16[6] = 255;
            nArray16[7] = 16311775;
            nArray3 = nArray16;
            nArray16[8] = 15646898;
        } else {
            int[] nArray17 = new int[9];
            nArray17[0] = -1;
            nArray17[1] = -858993460;
            nArray17[2] = -1714644583;
            nArray17[3] = 0x66996666;
            nArray17[4] = 0x33660000;
            nArray17[5] = 0;
            nArray17[6] = 255;
            nArray17[7] = 0xFFCCCC;
            nArray3 = nArray17;
            nArray17[8] = 0xFF9999;
        }
        oracleColorSchemeArray[4] = new OracleColorScheme("Red", "Oracle Red Color Scheme", nArray3, 4);
        if (__USE_HIGH_COLOR) {
            int[] nArray18 = new int[9];
            nArray18[0] = -1;
            nArray18[1] = -858993460;
            nArray18[2] = -1720141126;
            nArray18[3] = 1718783887;
            nArray18[4] = 859196492;
            nArray18[5] = 0;
            nArray18[6] = 255;
            nArray18[7] = 14678255;
            nArray2 = nArray18;
            nArray18[8] = 11726551;
        } else {
            int[] nArray19 = new int[9];
            nArray19[0] = -1;
            nArray19[1] = -858993460;
            nArray19[2] = -1721329255;
            nArray19[3] = 0x66336666;
            nArray19[4] = 0x33003333;
            nArray19[5] = 0;
            nArray19[6] = 255;
            nArray19[7] = 0x99FFFF;
            nArray2 = nArray19;
            nArray19[8] = 52428;
        }
        oracleColorSchemeArray[5] = new OracleColorScheme("Teal", "Oracle Teal Color Scheme", nArray2, 5);
        if (__USE_HIGH_COLOR) {
            int[] nArray20 = new int[9];
            nArray20[0] = -1;
            nArray20[1] = -858993460;
            nArray20[2] = -1717986919;
            nArray20[3] = 0x66666666;
            nArray20[4] = 0x33333333;
            nArray20[5] = 0;
            nArray20[6] = 255;
            nArray20[7] = 14678255;
            nArray = nArray20;
            nArray20[8] = 11726551;
        } else {
            int[] nArray21 = new int[9];
            nArray21[0] = -1;
            nArray21[1] = -858993460;
            nArray21[2] = -1717986919;
            nArray21[3] = 0x66666666;
            nArray21[4] = 0x33333333;
            nArray21[5] = 0;
            nArray21[6] = 255;
            nArray21[7] = 0x99FFFF;
            nArray = nArray21;
            nArray21[8] = 52428;
        }
        oracleColorSchemeArray[6] = new OracleColorScheme("Titanium", "Oracle Titanium Color Scheme", nArray, 6);
        oracleColorSchemeArray[7] = new OracleColorScheme("System", "System Hue and Saturation", SystemColor.control, SystemColor.textHighlight, false, 7);
        oracleColorSchemeArray[8] = new OracleBrowserColorScheme(8);
        oracleColorSchemeArray[9] = new OracleSwanColorScheme(9);
        oracleColorSchemeArray[10] = new OracleCustomizableColorScheme(10);
        _sAvailableSchemes = oracleColorSchemeArray;
        _sDefaultScheme = _sAvailableSchemes[6];
        _COMMON_SCHEME_DEFAULTS = new UIDefaults[_sAvailableSchemes.length];
        _LUM_SCHEME_DEFAULTS = new UIDefaults[_sAvailableSchemes.length * 2];
        _UI_DEFAULTS = new MultiUIDefaults[_sAvailableSchemes.length * 2];
    }
}

