/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

public final class InputEventUtils {
    public static final int ALT_GRAPH_MASK = 32;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_DOWN_MASK = 512;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_DOWN_MASK = 4096;
    public static final int BUTTON1_CHANGED_MASK = 8192;
    public static final int BUTTON2_CHANGED_MASK = 16384;
    public static final int BUTTON3_CHANGED_MASK = 32768;

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 0x10) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 8) == 8;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) == 4;
    }

    public static final boolean equals(int n, int n2) {
        return InputEventUtils._filterModifiers(n) == InputEventUtils._filterModifiers(n2);
    }

    public static final boolean isOnlyShiftDown(InputEvent inputEvent) {
        return InputEventUtils._filterModifiers(inputEvent.getModifiers()) == 1;
    }

    public static final boolean isOnlyControlDown(InputEvent inputEvent) {
        return InputEventUtils._filterModifiers(inputEvent.getModifiers()) == 2;
    }

    public static final int getMods(InputEvent inputEvent) {
        return InputEventUtils._filterModifiers(inputEvent.getModifiers());
    }

    private static final int _filterModifiers(int n) {
        if ((n & 0x40) != 0) {
            n &= 0xFFFFFFBF;
            n |= 1;
        }
        if ((n & 0x100) != 0) {
            n &= 0xFFFFFEFF;
            n |= 4;
        }
        if ((n & 0x200) != 0) {
            n &= 0xFFFFFDFF;
            n |= 8;
        }
        if ((n & 0x80) != 0) {
            n &= 0xFFFFFF7F;
            n |= 2;
        }
        if ((n & 0x400) != 0) {
            n &= 0xFFFFFBFF;
            n |= 0x10;
        }
        if ((n & 0x800) != 0) {
            n &= 0xFFFFF7FF;
            n |= 8;
        }
        if ((n & 0x1000) != 0) {
            n &= 0xFFFFEFFF;
            n |= 4;
        }
        n &= 0xFFFFDFFF;
        n &= 0xFFFFBFFF;
        return n &= 0xFFFF7FFF;
    }

    private InputEventUtils() {
    }
}

