/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.controller;

import oracle.xml.pipeline.controller.PipelineException;

class SyncQueue {
    private Object[] array;
    static final int INITIAL_QUEUE_SIZE = 15;
    private int size = 15;
    int curr = 0;
    int free = 0;
    boolean full = false;

    SyncQueue() {
        this.array = new Object[this.size];
    }

    SyncQueue(int n) {
        this.size = n <= 0 ? 15 : n;
        this.array = new Object[this.size];
    }

    synchronized void add(Object object) throws PipelineException {
        if (this.full) {
            throw new PipelineException("Queue is full!");
        }
        this.array[this.free++] = object;
        if (this.free == this.curr) {
            this.full = true;
        } else if (this.free == this.size) {
            if (this.curr == 0) {
                this.full = true;
            }
            this.free = 0;
        }
    }

    synchronized Object getNext() {
        if (this.curr == this.free && !this.full) {
            return null;
        }
        Object object = this.array[this.curr++];
        if (this.curr == this.size) {
            this.curr = 0;
        }
        this.full = false;
        return object;
    }

    synchronized int getCount() {
        if (this.free > this.curr) {
            return this.free - this.curr;
        }
        if (this.free == this.curr) {
            if (this.full) {
                return this.size;
            }
            return 0;
        }
        return this.free + this.size - this.curr;
    }
}

