/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.border;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

final class ShadowGradient
implements PaintContext {
    private Color _color;
    private int _shadeSize;
    private Rectangle _rect;
    private double _multiplier;

    ShadowGradient(Rectangle rect, Color color, int shadeSize, double shadeIntensity) {
        this._shadeSize = shadeSize;
        this._color = color;
        this._rect = rect;
        this._multiplier = shadeIntensity * 255.0 / (double)this._shadeSize;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int x, int y, int width, int height) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(width, height);
        int rectX = this._rect.x;
        int rectY = this._rect.y;
        int rectWidth = this._rect.width;
        int rectHeight = this._rect.height;
        int red = this._color.getRed();
        int green = this._color.getGreen();
        int blue = this._color.getBlue();
        int[] data = new int[width * height * 4];
        int dataPos = 0;
        for (int yPos = 0; yPos < height; ++yPos) {
            int thisY = y + yPos;
            for (int xPos = 0; xPos < width; ++xPos) {
                double distance;
                int thisX = x + xPos;
                int outcode = this._rect.outcode(thisX, thisY);
                switch (outcode) {
                    case 0: {
                        distance = 0.0;
                        break;
                    }
                    case 3: {
                        distance = Math.min((double)this._shadeSize, Point.distance(rectX, rectY, thisX, thisY));
                        break;
                    }
                    case 2: {
                        distance = rectY - thisY;
                        break;
                    }
                    case 6: {
                        distance = Math.min((double)this._shadeSize, Point.distance(rectX + rectWidth, rectY, thisX, thisY));
                        break;
                    }
                    case 1: {
                        distance = rectX - thisX;
                        break;
                    }
                    case 4: {
                        distance = thisX - (rectX + rectWidth);
                        break;
                    }
                    case 9: {
                        distance = Math.min((double)this._shadeSize, Point.distance(rectX, rectY + rectHeight, thisX, thisY));
                        break;
                    }
                    case 8: {
                        distance = thisY - (rectY + rectHeight);
                        break;
                    }
                    case 12: {
                        distance = Math.min((double)this._shadeSize, Point.distance(rectX + rectWidth, rectY + rectHeight, thisX, thisY));
                        break;
                    }
                    default: {
                        distance = 0.0;
                    }
                }
                double alpha = ((double)this._shadeSize - distance) * this._multiplier;
                int base = dataPos++ << 2;
                data[base + 0] = red;
                data[base + 1] = green;
                data[base + 2] = blue;
                data[base + 3] = (int)alpha;
            }
        }
        raster.setPixels(0, 0, width, height, data);
        return raster;
    }
}

