/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.border.Border;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;
import oracle.javatools.ui.checklist.Step;
import oracle.javatools.ui.checklist.StepHeader;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;

public final class StepPanel
extends LWComponent
implements Accessible {
    private static final Border _BORDER = new BorderAdapter((BorderPainter)new StepPanelBorderPainter());
    private static final int ANIMATION_DURATION = 350;
    private static final float ANIMATION_ACCELERATION = 1.0f;
    private Step _step;
    private Component _stepContent;
    private StepHeader _sHeader;
    private Listener _listener;
    private boolean _animationEnabled = true;
    private transient TimingController _animationTimer;

    public StepPanel(Step step) {
        this._step = step;
        this.setLayout(new BorderLayout());
        this.setStepHeader(this.createDefaultStepHeader());
        this._setContent();
        this._listener = new Listener();
        this._step.addPropertyChangeListener(this._listener);
        this.setBorder(_BORDER);
    }

    public Step getStep() {
        return this._step;
    }

    public StepHeader createDefaultStepHeader() {
        return new StepHeader(this.getStep());
    }

    public void setStepHeader(StepHeader stepHeader) {
        if (this._sHeader != null) {
            this.remove((Component)((Object)this._sHeader));
        }
        this._sHeader = stepHeader;
        if (this._sHeader != null) {
            this.add((Component)((Object)this._sHeader), "North");
        }
    }

    public StepHeader getStepHeader() {
        return this._sHeader;
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        if (this._animationEnabled != animationEnabled) {
            this._animationEnabled = animationEnabled;
            this.firePropertyChange("animationEnabled", !animationEnabled, animationEnabled);
        }
    }

    public boolean isAnimationEnabled() {
        return this._animationEnabled;
    }

    public int getPaintState() {
        int state = super.getPaintState();
        if (this._step.isSelected()) {
            state |= 0x20;
        }
        return state;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePanel();
        }
        return this.accessibleContext;
    }

    boolean isBeingAnimated() {
        return this._animationTimer != null;
    }

    private void _setContent() {
        if (this._stepContent != null) {
            this.remove(this._stepContent);
        }
        this._stepContent = this._step.getContent() != null ? this._step.getContent().getComponent() : null;
        if (this._stepContent != null) {
            this.add(this._stepContent, "Center");
            this._stepContent.setVisible(this._step.isExpanded());
        }
    }

    private void _expand() {
        if (this._animationTimer != null) {
            this._animationTimer.stop();
            this._stepContent.setPreferredSize(null);
        }
        this._stepContent.setVisible(true);
        this.revalidate();
    }

    private void _collapse() {
        if (this.isAnimationEnabled()) {
            TimingTarget tgt = new TimingTarget(){

                public void end() {
                    StepPanel.this._stepContent.setVisible(false);
                    StepPanel.this._stepContent.setPreferredSize(null);
                    StepPanel.this._animationTimer = null;
                }

                public void begin() {
                }

                public void timingEvent(long l, long l1, float f) {
                    float value = 1.0f - f;
                    Dimension size = null;
                    if (value > 0.0f) {
                        size = StepPanel.this._stepContent.getPreferredSize();
                        size.height = (int)((double)size.height * (double)value);
                    }
                    StepPanel.this._stepContent.setPreferredSize(size);
                    StepPanel.this.revalidate();
                }
            };
            this._animationTimer = new TimingController(new Cycle(350, 5), new Envelope(1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.HOLD), tgt);
            this._animationTimer.setAcceleration(1.0f);
            this._animationTimer.start();
        } else {
            this._stepContent.setVisible(false);
            this.revalidate();
        }
    }

    private class AccessiblePanel
    extends JComponent.AccessibleJComponent {
        private AccessiblePanel() {
            super((JComponent)((Object)StepPanel.this));
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            String propName = pe.getPropertyName();
            if ("expanded".equals(propName)) {
                if (Boolean.TRUE.equals(pe.getNewValue())) {
                    StepPanel.this._expand();
                } else {
                    StepPanel.this._collapse();
                }
            } else if ("visible".equals(propName)) {
                StepPanel.this.setVisible(Boolean.TRUE.equals(pe.getNewValue()));
            } else if ("content".equals(propName)) {
                StepPanel.this._setContent();
            } else if ("selected".equals(propName)) {
                StepPanel.this.repaint();
            }
        }
    }

    private static class StepPanelBorderPainter
    extends AbstractBorderPainter {
        private static final ImmInsets _INSET = new ImmInsets(0, 1, 1, 1);

        private StepPanelBorderPainter() {
        }

        protected boolean isBorderTransparent(PaintContext context) {
            return true;
        }

        protected ImmInsets getOwnInsets(PaintContext context) {
            return _INSET;
        }

        protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            int bottom = y + height - 1;
            int right = x + width - 1;
            if ((context.getPaintState() & 0x20) != 0) {
                g.setColor(new Color(49, 106, 196));
            } else {
                g.setColor(new Color(204, 204, 204));
            }
            g.drawLine(x, y, x, bottom - 1);
            g.drawLine(right, y, right, bottom);
            g.drawLine(x, bottom, right - 1, bottom);
            g.setColor(oldColor);
        }
    }
}

